﻿Public Class Form1
    Private DevStatus(15) As Boolean ' Device Connection Flag TRUE : connecting
    Private IdDevForm(15) As DevForm ' Device Control Panel Form Object

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim DevId As Short

        Timer1.Interval = 300
        Timer1.Enabled = True

        DevIdSel.SelectedIndex = 0

        'Initialize
        For DevId = 0 To 15
            DevStatus(DevId) = False 'Device is not Connected
        Next DevId
    End Sub

    ' Main Form Unload ( Program exit )
    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Dim DevId As Short

        Timer1.Enabled = False
        For DevId = 0 To 15
            If (IdDevForm(DevId) IsNot Nothing) Then
                If (IdDevForm(DevId).Visible) Then
                    IdDevForm(DevId) = Nothing ' Device Control Panel Unload
                    DevStatus(DevId) = False
                    TUSBKINS_Device_Close(DevId)
                End If
            End If
        Next DevId
    End Sub

    ' Device Control Panel Open
    Private Sub OpenPanel(ByVal Id As Short)
        DevStatus(Id) = True
        IdDevForm(Id) = New DevForm() 'Device Control Panel Form Create
        IdDevForm(Id).SetId(Id)
        IdDevForm(Id).Show() ' Form Show
    End Sub

    Private Sub OpenBtn_Click(sender As System.Object, e As System.EventArgs) Handles OpenBtn.Click
        Dim DevId As Short

        DevId = DevIdSel.SelectedIndex
        If DevStatus(DevId) = False Then ' Device is not connected
            If TUSBKINS_Device_Open(DevId) = 0 Then ' Connection check
                OpenPanel(DevId) '
            End If
        End If
    End Sub

    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        Dim DevId As Short

        For DevId = 0 To 15
            If DevStatus(DevId) Then
                If IdDevForm(DevId).Visible = False Then ' Device is not visible
                    TUSBKINS_Device_Close(DevId)
                    DevStatus(DevId) = False
                End If
            End If
        Next DevId
    End Sub

    Private Sub EndBtn_Click(sender As System.Object, e As System.EventArgs) Handles EndBtn.Click
        Me.Close()
    End Sub
End Class
