﻿'-----------------------------------------------
'TUSB-KINSxx Sample Program
'Visual Basic
'
'Jan. 14 2014
'Copyright (C) 2014 Turtle Industry Co.,Ltd.
'-----------------------------------------------
Public Class DevForm
    Inherits System.Windows.Forms.Form

    Private DevId As Integer         'Device Id

    Private ChangeEn As Boolean     '出力操作の可不可
    'チェックボックスコントロール用配列を作成
    Private OUTB() As System.Windows.Forms.CheckBox
    'ラベルコントロール用配列を作成
    Private INST() As System.Windows.Forms.Label

    ' check bit set
    ' bit -> 0~
    Private Function BitCheck(ByVal Data As Integer, ByVal bit As Integer) As Boolean
        Return ((Data And (1 << bit)) <> 0)
    End Function

    ' Initialize this Form module
    Public Sub SetId(ByVal Id As Short)
        Dim retErr As Short
        Dim Bit As Byte
        Dim InData As Integer
        Dim OutStatus As Integer
        Dim devType As Byte

        DevId = Id 'Set Device ID

        retErr = TUSBKINS_Type(DevId, devType) 'Get connected device type
        If retErr Then
            TUSBKINS_ErrorDisp(retErr)
            Me.Close()
            Return
        Else
            Select Case (devType)
                Case 0 'TUSB-KINS4/4
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-INS4/4"
                Case 1 'TUSB-KINS08O
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-KINS08O"
                Case 2 'TUSB-KINS08I
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-KINS08I"
                Case 3 'TUSB-KINS8/8
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-KINS8/8"
                Case 4 'TUSB-KINS16O
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-KINS16O"
                Case 5 'TUSB-KINS16I
                    Me.Text = "ID = " + DevId.ToString() + "  TUSB-KINS16I"
            End Select
        End If

        retErr = TUSBKINS_Read(DevId, InData, OUTStatus)
        If retErr Then
            TUSBKINS_ErrorDisp(retErr)
            Me.Close()
            Return
        End If

        ChangeEn = False
        For Bit = 0 To 15
            OUTB(Bit).Checked = BitCheck(OutStatus, Bit)
        Next Bit
        ChangeEn = True

        IoCheck()

        Timer1.Interval = 100
        Timer1.Enabled = True ' Start device connection check timer
    End Sub

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        'チェックボックスのインスタンスを配列にコピーして配列化する
        Me.OUTB = New System.Windows.Forms.CheckBox() _
            {Me.OUTB0, Me.OUTB1, Me.OUTB2, Me.OUTB3, _
            Me.OUTB4, Me.OUTB5, Me.OUTB6, Me.OUTB7, _
            Me.OUTB8, Me.OUTB9, Me.OUTB10, Me.OUTB11, _
            Me.OUTB12, Me.OUTB13, Me.OUTB14, Me.OUTB15}
        'ラベルコントロールのインスタンスを配列にコピーして配列化する
        Me.INST = New System.Windows.Forms.Label() _
            {Me.INST0, Me.INST1, Me.INST2, Me.INST3, _
            Me.INST4, Me.INST5, Me.INST6, Me.INST7, _
            Me.INST8, Me.INST9, Me.INST10, Me.INST11, _
            Me.INST12, Me.INST13, Me.INST14, Me.INST15}
    End Sub

    'Input status check routine
    Private Sub IoCheck()
        Dim retErr As Short
        Dim InData As Integer
        Dim tmpLong As Integer
        Dim Bit As Short

        retErr = TUSBKINS_Read(DevId, InData, tmpLong) 'Input status read
        If retErr Then
            TUSBKINS_ErrorDisp(retErr)
            Me.Close()
            Return
        End If

        For Bit = 0 To 15
            INST(Bit).Text = IIf(BitCheck(InData, Bit), "On", "Off")
        Next Bit
    End Sub

    'Output checkbox click handler
    Private Sub OUTB_Changed()
        Dim retErr As Short
        Dim index As Integer
        Dim tmpB As Integer

        tmpB = 0

        For index = 0 To 15
            If OUTB(index).CheckState = CheckState.Checked Then
                tmpB += (1 << index)
            End If
        Next

        retErr = TUSBKINS_Write(DevId, tmpB) 'Output
        If retErr Then
            TUSBKINS_ErrorDisp(retErr)
        End If
    End Sub

    Private Sub OUTB_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles OUTB9.CheckedChanged, OUTB8.CheckedChanged, OUTB7.CheckedChanged, OUTB6.CheckedChanged, OUTB5.CheckedChanged, OUTB4.CheckedChanged, OUTB3.CheckedChanged, OUTB2.CheckedChanged, OUTB15.CheckedChanged, OUTB14.CheckedChanged, OUTB13.CheckedChanged, OUTB12.CheckedChanged, OUTB11.CheckedChanged, OUTB10.CheckedChanged, OUTB1.CheckedChanged, OUTB0.CheckedChanged
        If ChangeEn Then
            OUTB_Changed()
        End If
    End Sub

    ' Device connection check routine
    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        IoCheck() ' Input status check
    End Sub
End Class