﻿//-----------------------------------------------
//TUSB-KINSxx用ドライバアクセス用API
//Visual C# 用モジュール
//
//2014_01_14　株式会社タートル工業
//Copyright (C) 2014 Turtle Industry Co.,Ltd.
//-----------------------------------------------

using System.Runtime.InteropServices;

class TUSBKINS
{
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_Device_Open(short Id);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern void TUSBKINS_Device_Close(short Id);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_Write(short Id, int Data);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_Read(short Id, out int InData, out int OUTStatus);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_EdgeSet(short Id, int Data, byte Time);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_EdgeRead(short Id, out int Data);
    [DllImport("TUSBKINS.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBKINS_Type(short Id, out byte devType);
    public static string GetErrMessage(short retcode)
    {
        switch (retcode)
        {
            case 0:
                return "正常終了しました";
            case 1:
                return "ID番号が不正です";
            case 2:
                return "ドライバがインストールされていません";
            case 3:
                return "すでにデバイスはオープンされています";
            case 4:
                return "接続されている台数が多すぎます";
            case 5:
                return "オープンできませんでした";
            case 6:
                return "デバイスがみつかりません";
            case 8:
                return "パラメータエラー";
            case 9:
                return "USB通信エラーです";
            default:
                return "不明なエラーです";
        }
    }
}

