﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KINSxxSample
{
    public partial class DevForm : Form
    {
        public short DevId;     //Device Id

        private Boolean ChangeEn;     //出力操作の可不可
        // チェックボックスコントロール用配列を作成
        private System.Windows.Forms.CheckBox[] OUTB;
        // ラベルコントロール用配列を作成
        private System.Windows.Forms.Label[] INST;

        public DevForm()
        {
            InitializeComponent();
            // チェックボックスのインスタンスを配列にコピーして配列化する
            this.OUTB = new System.Windows.Forms.CheckBox[]
                {this.OUTB0, this.OUTB1, this.OUTB2, this.OUTB3,
                this.OUTB4, this.OUTB5, this.OUTB6, this.OUTB7,
                this.OUTB8, this.OUTB9, this.OUTB10, this.OUTB11,
                this.OUTB12, this.OUTB13, this.OUTB14, this.OUTB15};
            // ラベルコントロールのインスタンスを配列にコピーして配列化する
            this.INST = new System.Windows.Forms.Label[]
                {this.INST0, this.INST1, this.INST2, this.INST3,
                this.INST4, this.INST5, this.INST6, this.INST7,
                this.INST8, this.INST9, this.INST10, this.INST11,
                this.INST12, this.INST13, this.INST14, this.INST15};
        }

        // check bit
        // bit -> 0~
        private Boolean BitCheck(int Data, int bit)
        {
            return ((Data & (1 << bit)) != 0);
        }

        // Initialize this Form module
        public void SetId(short Id)
        {
            short retErr;
            byte Bit;
            int InData;
            int OutStatus;
            byte devType;

            DevId = Id; // Set Device ID

            retErr = TUSBKINS.TUSBKINS_Type(DevId, out devType); //Get connected device type
            if (retErr != 0)
            {
                MessageBox.Show(TUSBKINS.GetErrMessage(retErr));
                this.Close();
                return;
            }

            switch (devType)
            {
                case 0: //TUSB-KINS4/4
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-INS4/4";
                    break;
                case 1: //TUSB-KINS08O
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-KINS08O";
                    break;
                case 2: //TUSB-KINS08I
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-KINS08I";
                    break;
                case 3: //TUSB-KINS8/8
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-KINS8/8";
                    break;
                case 4: //TUSB-KINS16O
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-KINS16O";
                    break;
                case 5: //TUSB-KINS16I
                    this.Text = "ID = " + DevId.ToString() + "  TUSB-KINS16I";
                    break;
            }

            retErr = TUSBKINS.TUSBKINS_Read(DevId, out InData, out OutStatus);
            if (retErr != 0)
            {
                MessageBox.Show(TUSBKINS.GetErrMessage(retErr));
                this.Close();
                return;
            }

            ChangeEn = false;
            for (Bit = 0; Bit < 16; Bit++)
                OUTB[Bit].Checked = BitCheck(OutStatus, Bit);
            ChangeEn = true;

            IoCheck();

            Timer1.Interval = 100;
            Timer1.Enabled = true; //  Start device connection check timer
        }

        // Input status check routine
        private void IoCheck()
        {
            short retErr;
            int InData;
            int tmpLong;
            short Bit;

            retErr = TUSBKINS.TUSBKINS_Read(DevId, out InData, out tmpLong); //Input status read
            if (retErr != 0)
            {
                MessageBox.Show(TUSBKINS.GetErrMessage(retErr));
                this.Close();
                return;
            }

            for (Bit = 0; Bit < 16; Bit++)
            {
                INST[Bit].Text = BitCheck(InData, Bit) ? "On" : "Off";
            }
        }

        //Output checkbox click handler
        private void OUTB_Changed()
        {
            short retErr;
            int index;
            int tmpB;

            tmpB = 0;

            for (index = 0; index < 16; index++)
            {
                if (OUTB[index].CheckState == CheckState.Checked)
                    tmpB += (1 << index);
            }

            retErr = TUSBKINS.TUSBKINS_Write(DevId, tmpB); // Output
            if (retErr != 0)
            {
                MessageBox.Show(TUSBKINS.GetErrMessage(retErr));
            }
        }

        private void OUTB_CheckedChanged(object sender, EventArgs e)
        {
            if (ChangeEn)
                OUTB_Changed();
        }

        //Device connection check routine
        private void Timer1_Tick(object sender, EventArgs e)
        {
            IoCheck(); // Input status check
        }
    }
}

