'-----------------------------------------------
'API for TUSB-K01DA Driver
'Visual Basic .NET Module WinUSB Version
'
'Mar. 15 2013
'Copyright (C) 2013 Turtle Industry Co.,Ltd.
'-----------------------------------------------
Option Strict Off
Option Explicit On
Imports System.Runtime.InteropServices

Module TUSBKDA

    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_Device_Open(ByVal Id As Short) As Short
    End Function

    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Sub TUSBK01DA_Device_Close(ByVal Id As Short)
    End Sub
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_DacOut(ByVal Id As Short, _
                              ByVal data As Short) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_IntClk(ByVal clk As Integer) As Double
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_Da_Start(ByVal Id As Short, _
                                ByVal clk As Integer, _
                                ByVal dLen As Short) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_Da_Stop(ByVal Id As Short) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_Da_Status(ByVal Id As Short, _
                               ByRef Status As Byte) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_Data_Set(ByVal Id As Short, _
                                <[In](), Out()> ByVal data() As Short, _
                                ByVal Leng As Short) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_ExtTimer(ByVal clk As Integer) As Double
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_ExtTimer_Set(ByVal Id As Short, _
                                    ByVal clk As Integer) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_DIO_Dir(ByVal Id As Short, _
                               ByVal b As Byte, _
                               ByVal direction As Byte) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_DIO_Out(ByVal Id As Short, _
                               ByVal b As Byte, _
                               ByVal data As Byte) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_DIO_In(ByVal Id As Short, _
                              ByRef data As Byte) As Short
    End Function
    <DllImport("TUSBKDA.DLL", CallingConvention:=CallingConvention.Cdecl)> _
    Function TUSBK01DA_DIO_Status(ByVal Id As Short, _
                                  <[In](), Out()> ByVal data() As Byte) As Short
    End Function

    ' Error Message
    Public Sub TUSBK01DA_ErrorDisp(ByVal ErrCode As Short)
        Dim message As String

        Select Case ErrCode
            Case 0
                message = "ɏI܂"
            Case 1
                message = "IDԍsł"
            Case 2
                message = "hCoĂ܂"
            Case 3
                message = "łɃfoCXI[vĂ܂"
            Case 4
                message = "ڑ䐔܂"
            Case 5
                message = "I[vo܂ł"
            Case 6
                message = "foCX܂ł"
            Case 8
                message = "p[^G["
            Case 9
                message = "USBʐMG["
            Case Else
                message = "sȃG[ł"
        End Select

        MsgBox(message)
    End Sub
End Module