﻿'-----------------------------------------------
'TUSB-K01DA Sample Program
'Visual Basic
'
'Jan. 15 2014
'Copyright (C) 2014 Turtle Industry Co.,Ltd.
'-----------------------------------------------
Public Class DevForm
    Private DevId As Short          'Device Id

    Private IOStatus() As Byte      'DIO Status

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        IOStatus = New Byte(1) {}
    End Sub

    'This Form module initialize
    Public Sub SetId(ByVal Id As Short)
        Dim retErr As Short

        DevId = Id

        Me.Text = "ID = " & DevId.ToString() & "  Panel"
        retErr = TUSBK01DA_DIO_Status(DevId, IOStatus)
        If retErr <> 0 Then
            TUSBK01DA_ErrorDisp(retErr)
            Me.Hide()
            Return
        Else
            IOSEL1.SelectedIndex = IOStatus(0)
            IOSEL2.SelectedIndex = IOStatus(1)
        End If

        ExtClock.Text = "1000"
        ExtClockValueCheck()
        IntClockValueCheck()
        SelIntClk.Checked = True
        Timer1.Interval = 100
        Timer1.Enabled = True
        WAVE_SHAPE.SelectedIndex = 0
    End Sub

    Private Sub DevForm_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
        Timer1.Enabled = False
    End Sub

    Private Sub DevForm_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.VisibleChanged
        If Me.Visible = False Then
            Timer1.Enabled = False
        End If
    End Sub

    ' Enable Disable change of controls
    Private Sub EnableDisableCont(ByVal StartStop As Boolean)
        If StartStop Then 'Start ( on data recording )
            DacStop.Enabled = True
            DacStart.Enabled = False
            SelExtClock.Enabled = False
            SelIntClk.Enabled = False
            WAVE_SHAPE.Enabled = False
            AMPL.Enabled = False
            OFFSET.Enabled = False
            DATA_LENG.Enabled = False
        Else 'Stop
            DacStop.Enabled = False
            DacStart.Enabled = True
            SelExtClock.Enabled = True
            SelIntClk.Enabled = True
            WAVE_SHAPE.Enabled = True
            AMPL.Enabled = True
            OFFSET.Enabled = True
            DATA_LENG.Enabled = True
        End If
    End Sub

    ' Digital Port Direction Change
    Private Sub SetDir(ByVal b As Byte)
        Dim Direction As Byte
        Dim retErr As Short

        If IOStatus(b) <> 0 Then
            Direction = 1
        Else
            Direction = 0
        End If

        retErr = TUSBK01DA_DIO_Dir(DevId, b, Direction)
        If retErr Then
            TUSBK01DA_ErrorDisp(retErr)
        End If
    End Sub

    'Digital Port Output Level
    Private Sub SetDio(ByVal b As Byte)
        Dim data As Byte
        Dim retErr As Short

        If IOStatus(b) = 2 Then
            data = 1
        Else
            data = 0
        End If

        retErr = TUSBK01DA_DIO_Out(DevId, b, data)
        If retErr Then
            TUSBK01DA_ErrorDisp(retErr)
        End If
    End Sub

    'setup of Digital IO 1 state
    Private Sub IOSEL1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles IOSEL1.SelectedIndexChanged
        Select Case IOSEL1.SelectedIndex
            Case 0 'INPUT
                IOStatus(0) = IOSEL1.SelectedIndex
                SetDir(0)
            Case 1 'OUTPUT Low
                IOStatus(0) = IOSEL1.SelectedIndex
                SetDio(0)
                SetDir(0)
            Case 2 'OUTPUT High
                IOStatus(0) = IOSEL1.SelectedIndex
                SetDio(0)
                SetDir(0)
        End Select
    End Sub

    'setup of Digital IO 2 state
    Private Sub IOSEL2_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles IOSEL2.SelectedIndexChanged
        Dim retErr As Short

        Select Case IOSEL2.SelectedIndex
            Case 0 'INPUT
                IOStatus(1) = IOSEL2.SelectedIndex
                SetDir(1)
            Case 1 'OUTPUT Low
                IOStatus(1) = IOSEL2.SelectedIndex
                SetDio(1)
                SetDir(1)
            Case 2 'OUTPUT High
                IOStatus(1) = IOSEL2.SelectedIndex
                SetDio(1)
                SetDir(1)
            Case 3 'CLOCK
                retErr = TUSBK01DA_DIO_Status(DevId, IOStatus)
                If retErr <> 0 Then
                    TUSBK01DA_ErrorDisp(retErr)
                    Me.Hide()
                    Return
                ElseIf IOStatus(1) <> 3 Then
                    IOSEL2.SelectedIndex = IOStatus(1)
                End If
        End Select
    End Sub

    Private Sub DIO_Check()
        Dim data As Byte
        Dim retErr As Short

        retErr = TUSBK01DA_DIO_In(DevId, data)
        If retErr <> 0 Then
            TUSBK01DA_ErrorDisp(retErr)
            Me.Hide()
            Return
        End If
        D0State.Text = IIf((data And &H1S), "High", "Low")
        D1State.Text = IIf((data And &H2S), "High", "Low")
    End Sub

    ' Ext Clock Out Command
    Private Sub ClockOut_Click(sender As System.Object, e As System.EventArgs) Handles ClockOut.Click
        Dim Clock As Integer
        Dim retErr As Short

        If (Integer.TryParse(ExtClock.Text, Clock)) Then
            If (Clock < 1000 Or Clock > 500000000) Then
                MessageBox.Show("Cycle is outside the range.")
            Else
                retErr = TUSBK01DA_ExtTimer_Set(DevId, Clock)
                If retErr <> 0 Then
                    TUSBK01DA_ErrorDisp(retErr)
                Else
                    IOSEL2.SelectedIndex = 3
                End If
            End If
        Else
            MessageBox.Show("An input value is invalid.")
        End If
    End Sub

    ' Ext Clock Value Check
    Private Sub ExtClockValueCheck()
        Dim tmpInt As Integer
        If ExtClockDisp.Text.Length >= 10 Then
            ExtClockDisp.Text = ""
        ElseIf Integer.TryParse(ExtClock.Text, tmpInt) Then
            ExtClockDisp.Text = TUSBK01DA_ExtTimer(tmpInt).ToString("N0")
        Else
            ExtClockDisp.Text = ""
        End If
    End Sub
    Private Sub ExtClock_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ExtClock.TextChanged
        ExtClockValueCheck()
    End Sub

    ' DAC Digital -> Analog Convert
    Private Sub DacConvert_Click(sender As System.Object, e As System.EventArgs) Handles DacConvert.Click
        Dim retErr As Short
        Dim Voltage As Double
        Dim iDigit As Short

        If Double.TryParse(DAC_DATA.Text, Voltage) Then
            If Voltage < -2.5 Or Voltage > 2.5 Then
                MessageBox.Show("入力値が不正です")
                Return
            End If
        Else
            MessageBox.Show("入力値が不正です")
            Return
        End If

        iDigit = Voltage / 2.5 * 8192 'Convert Voltage -> Integer
        If iDigit < -8192 Then
            iDigit = -8192
        ElseIf iDigit > 8191 Then
            iDigit = 8191
        End If

        retErr = TUSBK01DA_DacOut(DevId, iDigit)
        If retErr <> 0 Then
            TUSBK01DA_ErrorDisp(retErr)
        End If

        If DacStop.Enabled Then
            EnableDisableCont(False)
        End If
    End Sub

    Private Sub IntClockValueCheck()
        Dim tmpInt As Integer

        If IntClock.Text.Length < 11 Then
            If Integer.TryParse(IntClock.Text, tmpInt) Then
                IntClockDisp.Text = TUSBK01DA_IntClk(tmpInt).ToString("N0")
            Else
                IntClockDisp.Text = ""
            End If
        Else
            IntClockDisp.Text = ""
        End If
    End Sub
    Private Sub IntClock_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles IntClock.TextChanged
        IntClockValueCheck()
    End Sub

    '矩形波生成
    Private Function RectangleF(ByVal Arg As Double) As Double
        Arg /= (2.0 * Math.PI) 'スケール2Pi->1変換
        Arg -= Math.Floor(Arg) '鋸刃波形に変換
        If Arg < 0.5 Then
            Return 1.0
        Else
            Return -1.0
        End If
    End Function

    '三角波生成
    Private Function TriangleF(ByVal Arg As Double) As Double
        Arg /= (2.0 * Math.PI) 'スケール2Pi->1変換
        Arg -= Math.Floor(Arg) '鋸刃波形に変換
        Arg *= 4.0 'スケール1 -> 4変換
        If Arg < 1.0 Then
            Return Arg
        ElseIf Arg < 3.0 Then
            Return (2.0 - Arg)
        Else
            Return (Arg - 4.0)
        End If
    End Function

    '波形生成
    Private Sub MakeShape(ByRef data() As Double, ByVal Shape As Short, ByVal Leng As Integer, ByVal Amp As Double, ByVal OFFSET As Double)
        Dim cnt As Integer
        Dim angle As Double

        For cnt = 0 To (Leng - 1)
            angle = 2.0 * Math.PI * CDbl(cnt) / CDbl(Leng)
            Select Case (Shape)
                Case 0 '正弦波
                    data(cnt) = Amp * System.Math.Sin(angle) + OFFSET
                Case 1 '三角波
                    data(cnt) = Amp * TriangleF(angle) + OFFSET
                Case 2 '矩形波
                    data(cnt) = Amp * RectangleF(angle) + OFFSET
                Case Else
                    data(cnt) = 0
            End Select
        Next
    End Sub

    Private Sub DacStart_Click(sender As System.Object, e As System.EventArgs) Handles DacStart.Click
        Dim prm_DataLeng As Short
        Dim prm_Ampl As Double
        Dim prm_Offset As Double
        Dim prm_IntClock As Integer
        Dim DataD(4095) As Double
        Dim DataI(4095) As Short
        Dim cnt As Integer

        '設定値チェック
        If Short.TryParse(DATA_LENG.Text, prm_DataLeng) = False Then
            MessageBox.Show("DataLength設定に誤りがあります")
            Return
        End If
        If Double.TryParse(AMPL.Text, prm_Ampl) = False Then
            MessageBox.Show("Amplitude設定に誤りがあります")
            Return
        End If
        If Double.TryParse(OFFSET.Text, prm_Offset) = False Then
            MessageBox.Show("Offset設定に誤りがあります")
            Return
        End If
        If SelIntClk.Checked Then
            If Integer.TryParse(IntClock.Text, prm_IntClock) = False Then
                MessageBox.Show("IntClock設定に誤りがあります")
                Return
            End If
        End If

        '波形生成
        MakeShape(DataD, WAVE_SHAPE.SelectedIndex, prm_DataLeng, prm_Ampl / 2.0, prm_Offset)

        '整数(DACコード)化
        For cnt = 0 To (prm_DataLeng - 1)
            DataI(cnt) = DataD(cnt) * 8192.0 / 2.5
            If DataI(cnt) >= 8191 Then
                DataI(cnt) = 8191
            ElseIf DataI(cnt) <= -8192 Then
                DataI(cnt) = -8192
            End If
        Next cnt

        'データ設定
        TUSBK01DA_Data_Set(DevId, DataI, prm_DataLeng)
        '開始
        If (SelExtClock.Checked) Then
            TUSBK01DA_Da_Start(DevId, 0, prm_DataLeng)
        Else
            TUSBK01DA_Da_Start(DevId, prm_IntClock, prm_DataLeng)
        End If

        EnableDisableCont(True)
    End Sub

    Private Sub DacStop_Click(sender As System.Object, e As System.EventArgs) Handles DacStop.Click
        Dim retErr As Short

        retErr = TUSBK01DA_Da_Stop(DevId)
        If retErr Then
            TUSBK01DA_ErrorDisp(retErr)
        End If

        EnableDisableCont(False)
    End Sub

    ' timer handler
    Private Sub Timer1_Elapsed(ByVal sender As System.Object, ByVal e As System.Timers.ElapsedEventArgs) Handles Timer1.Elapsed
        Timer1.Enabled = False
        If (Me.Visible = False) Then
            Exit Sub
        Else
            DIO_Check()
            Timer1.Enabled = True
        End If
    End Sub
End Class