#pragma once

#include "TUSBKDA.h"

namespace K01DASample {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	/// <summary>
	/// DevForm ̊Tv
	/// </summary>
	public ref class DevForm : public System::Windows::Forms::Form
	{
	public:
		DevForm(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^[ R[hǉ܂
			//
			IOStatus = gcnew array<unsigned char>(2);
		}

	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~DevForm()
		{
			if (components)
			{
				delete components;
			}
		}
	public: System::Windows::Forms::ComboBox^  IOSEL2;
	protected: 
	public: System::Windows::Forms::Label^  Label11;
	public: System::Windows::Forms::Label^  D1State;
	public: System::Windows::Forms::Button^  ClockOut;
	public: System::Windows::Forms::Label^  Label2;
	internal: System::Windows::Forms::ComboBox^  IOSEL1;
	public: 
	internal: System::Windows::Forms::GroupBox^  GroupBox1;
	internal: System::Windows::Forms::Label^  D0State;
	internal: System::Windows::Forms::Label^  Label1;
	public: System::Windows::Forms::TextBox^  ExtClock;
	internal: 
	public: System::Windows::Forms::Label^  Label6;
	internal: System::Windows::Forms::GroupBox^  GroupBox3;
	public: 
	public: System::Windows::Forms::TextBox^  DAC_DATA;
	internal: 
	public: System::Windows::Forms::Button^  DacConvert;
	public: System::Windows::Forms::Label^  Label13;
	public: System::Windows::Forms::Label^  Label5;
	public: System::Windows::Forms::TextBox^  OFFSET;
	public: System::Windows::Forms::Label^  Label4;
	public: System::Windows::Forms::Label^  Label3;
	public: System::Windows::Forms::Label^  ExtClockDisp;
	internal: System::Windows::Forms::GroupBox^  GroupBox2;
	public: 
	public: System::Windows::Forms::TextBox^  DATA_LENG;
	internal: 
	public: System::Windows::Forms::TextBox^  AMPL;
	public: System::Windows::Forms::TextBox^  IntClock;
	public: System::Windows::Forms::RadioButton^  SelIntClk;
	public: System::Windows::Forms::RadioButton^  SelExtClock;
	public: System::Windows::Forms::Button^  DacStop;
	internal: System::Timers::Timer^  Timer1;
	public: 
	internal: System::Windows::Forms::GroupBox^  GroupBox4;
	public: System::Windows::Forms::ComboBox^  WAVE_SHAPE;
	internal: 
	public: System::Windows::Forms::Button^  DacStart;
	public: System::Windows::Forms::Label^  Label12;
	public: System::Windows::Forms::Label^  Label14;
	public: System::Windows::Forms::Label^  Label10;
	public: System::Windows::Forms::Label^  Label9;
	public: System::Windows::Forms::Label^  Label8;
	public: System::Windows::Forms::Label^  Label7;
	public: System::Windows::Forms::Label^  IntClockDisp;
	public: System::Windows::Forms::Label^  Label22;
	public: System::Windows::Forms::Label^  Label21;
	public: System::Windows::Forms::Label^  Label20;
	public: System::Windows::Forms::Label^  Label19;
	public: System::Windows::Forms::Label^  Label18;
	public:
		short DevId;                     //Device Id


	private:
		/// <summary>
		/// KvȃfUCi[ϐłB
		/// </summary>
		System::ComponentModel::Container ^components;
		array<unsigned char>^ IOStatus;//DIO Status

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi[ T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^[ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->IOSEL2 = (gcnew System::Windows::Forms::ComboBox());
			this->Label11 = (gcnew System::Windows::Forms::Label());
			this->D1State = (gcnew System::Windows::Forms::Label());
			this->ClockOut = (gcnew System::Windows::Forms::Button());
			this->Label2 = (gcnew System::Windows::Forms::Label());
			this->IOSEL1 = (gcnew System::Windows::Forms::ComboBox());
			this->GroupBox1 = (gcnew System::Windows::Forms::GroupBox());
			this->D0State = (gcnew System::Windows::Forms::Label());
			this->Label1 = (gcnew System::Windows::Forms::Label());
			this->ExtClock = (gcnew System::Windows::Forms::TextBox());
			this->Label6 = (gcnew System::Windows::Forms::Label());
			this->GroupBox3 = (gcnew System::Windows::Forms::GroupBox());
			this->DAC_DATA = (gcnew System::Windows::Forms::TextBox());
			this->DacConvert = (gcnew System::Windows::Forms::Button());
			this->Label13 = (gcnew System::Windows::Forms::Label());
			this->Label5 = (gcnew System::Windows::Forms::Label());
			this->OFFSET = (gcnew System::Windows::Forms::TextBox());
			this->Label4 = (gcnew System::Windows::Forms::Label());
			this->Label3 = (gcnew System::Windows::Forms::Label());
			this->ExtClockDisp = (gcnew System::Windows::Forms::Label());
			this->GroupBox2 = (gcnew System::Windows::Forms::GroupBox());
			this->DATA_LENG = (gcnew System::Windows::Forms::TextBox());
			this->AMPL = (gcnew System::Windows::Forms::TextBox());
			this->IntClock = (gcnew System::Windows::Forms::TextBox());
			this->SelIntClk = (gcnew System::Windows::Forms::RadioButton());
			this->SelExtClock = (gcnew System::Windows::Forms::RadioButton());
			this->DacStop = (gcnew System::Windows::Forms::Button());
			this->Timer1 = (gcnew System::Timers::Timer());
			this->WAVE_SHAPE = (gcnew System::Windows::Forms::ComboBox());
			this->DacStart = (gcnew System::Windows::Forms::Button());
			this->Label12 = (gcnew System::Windows::Forms::Label());
			this->Label14 = (gcnew System::Windows::Forms::Label());
			this->Label10 = (gcnew System::Windows::Forms::Label());
			this->Label9 = (gcnew System::Windows::Forms::Label());
			this->Label8 = (gcnew System::Windows::Forms::Label());
			this->Label7 = (gcnew System::Windows::Forms::Label());
			this->IntClockDisp = (gcnew System::Windows::Forms::Label());
			this->Label22 = (gcnew System::Windows::Forms::Label());
			this->Label21 = (gcnew System::Windows::Forms::Label());
			this->Label20 = (gcnew System::Windows::Forms::Label());
			this->GroupBox4 = (gcnew System::Windows::Forms::GroupBox());
			this->Label19 = (gcnew System::Windows::Forms::Label());
			this->Label18 = (gcnew System::Windows::Forms::Label());
			this->GroupBox1->SuspendLayout();
			this->GroupBox3->SuspendLayout();
			this->GroupBox2->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->Timer1))->BeginInit();
			this->GroupBox4->SuspendLayout();
			this->SuspendLayout();
			// 
			// IOSEL2
			// 
			this->IOSEL2->BackColor = System::Drawing::SystemColors::Window;
			this->IOSEL2->Cursor = System::Windows::Forms::Cursors::Default;
			this->IOSEL2->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->IOSEL2->ForeColor = System::Drawing::SystemColors::WindowText;
			this->IOSEL2->Items->AddRange(gcnew cli::array< System::Object^  >(4) {L"INPUT", L"LOW", L"HIGH", L"CLOCK"});
			this->IOSEL2->Location = System::Drawing::Point(304, 24);
			this->IOSEL2->Name = L"IOSEL2";
			this->IOSEL2->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->IOSEL2->Size = System::Drawing::Size(65, 20);
			this->IOSEL2->TabIndex = 31;
			this->IOSEL2->SelectedIndexChanged += gcnew System::EventHandler(this, &DevForm::IOSEL2_SelectedIndexChanged);
			// 
			// Label11
			// 
			this->Label11->BackColor = System::Drawing::SystemColors::Control;
			this->Label11->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label11->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label11->Location = System::Drawing::Point(228, 24);
			this->Label11->Name = L"Label11";
			this->Label11->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label11->Size = System::Drawing::Size(25, 17);
			this->Label11->TabIndex = 40;
			this->Label11->Text = L"[V]";
			// 
			// D1State
			// 
			this->D1State->BackColor = System::Drawing::SystemColors::Control;
			this->D1State->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
			this->D1State->Cursor = System::Windows::Forms::Cursors::Default;
			this->D1State->ForeColor = System::Drawing::SystemColors::ControlText;
			this->D1State->Location = System::Drawing::Point(240, 24);
			this->D1State->Name = L"D1State";
			this->D1State->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->D1State->Size = System::Drawing::Size(49, 17);
			this->D1State->TabIndex = 32;
			this->D1State->TextAlign = System::Drawing::ContentAlignment::TopCenter;
			// 
			// ClockOut
			// 
			this->ClockOut->BackColor = System::Drawing::SystemColors::Control;
			this->ClockOut->Cursor = System::Windows::Forms::Cursors::Default;
			this->ClockOut->ForeColor = System::Drawing::SystemColors::ControlText;
			this->ClockOut->Location = System::Drawing::Point(20, 32);
			this->ClockOut->Name = L"ClockOut";
			this->ClockOut->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->ClockOut->Size = System::Drawing::Size(89, 25);
			this->ClockOut->TabIndex = 15;
			this->ClockOut->Text = L"Clock Out";
			this->ClockOut->UseVisualStyleBackColor = false;
			this->ClockOut->Click += gcnew System::EventHandler(this, &DevForm::ClockOut_Click);
			// 
			// Label2
			// 
			this->Label2->BackColor = System::Drawing::SystemColors::Control;
			this->Label2->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label2->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label2->Location = System::Drawing::Point(200, 24);
			this->Label2->Name = L"Label2";
			this->Label2->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label2->Size = System::Drawing::Size(25, 16);
			this->Label2->TabIndex = 30;
			this->Label2->Text = L"D1";
			// 
			// IOSEL1
			// 
			this->IOSEL1->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->IOSEL1->Items->AddRange(gcnew cli::array< System::Object^  >(3) {L"INPUT", L"LOW", L"HIGH"});
			this->IOSEL1->Location = System::Drawing::Point(112, 24);
			this->IOSEL1->Name = L"IOSEL1";
			this->IOSEL1->Size = System::Drawing::Size(64, 20);
			this->IOSEL1->TabIndex = 2;
			this->IOSEL1->SelectedIndexChanged += gcnew System::EventHandler(this, &DevForm::IOSEL1_SelectedIndexChanged);
			// 
			// GroupBox1
			// 
			this->GroupBox1->Controls->Add(this->IOSEL2);
			this->GroupBox1->Controls->Add(this->D1State);
			this->GroupBox1->Controls->Add(this->Label2);
			this->GroupBox1->Controls->Add(this->IOSEL1);
			this->GroupBox1->Controls->Add(this->D0State);
			this->GroupBox1->Controls->Add(this->Label1);
			this->GroupBox1->Location = System::Drawing::Point(16, 11);
			this->GroupBox1->Name = L"GroupBox1";
			this->GroupBox1->Size = System::Drawing::Size(400, 56);
			this->GroupBox1->TabIndex = 12;
			this->GroupBox1->TabStop = false;
			this->GroupBox1->Text = L"DIO";
			// 
			// D0State
			// 
			this->D0State->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
			this->D0State->Location = System::Drawing::Point(56, 24);
			this->D0State->Name = L"D0State";
			this->D0State->Size = System::Drawing::Size(48, 16);
			this->D0State->TabIndex = 1;
			this->D0State->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
			// 
			// Label1
			// 
			this->Label1->Location = System::Drawing::Point(16, 24);
			this->Label1->Name = L"Label1";
			this->Label1->Size = System::Drawing::Size(24, 16);
			this->Label1->TabIndex = 0;
			this->Label1->Text = L"D0";
			// 
			// ExtClock
			// 
			this->ExtClock->AcceptsReturn = true;
			this->ExtClock->BackColor = System::Drawing::SystemColors::Window;
			this->ExtClock->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->ExtClock->ForeColor = System::Drawing::SystemColors::WindowText;
			this->ExtClock->Location = System::Drawing::Point(212, 16);
			this->ExtClock->MaxLength = 0;
			this->ExtClock->Name = L"ExtClock";
			this->ExtClock->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->ExtClock->Size = System::Drawing::Size(129, 19);
			this->ExtClock->TabIndex = 13;
			this->ExtClock->Text = L"1000";
			this->ExtClock->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			this->ExtClock->TextChanged += gcnew System::EventHandler(this, &DevForm::ExtClock_TextChanged);
			// 
			// Label6
			// 
			this->Label6->BackColor = System::Drawing::SystemColors::Control;
			this->Label6->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label6->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label6->Location = System::Drawing::Point(148, 40);
			this->Label6->Name = L"Label6";
			this->Label6->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label6->Size = System::Drawing::Size(41, 17);
			this->Label6->TabIndex = 19;
			this->Label6->Text = L"Actual";
			// 
			// GroupBox3
			// 
			this->GroupBox3->Controls->Add(this->DAC_DATA);
			this->GroupBox3->Controls->Add(this->DacConvert);
			this->GroupBox3->Controls->Add(this->Label13);
			this->GroupBox3->Controls->Add(this->Label11);
			this->GroupBox3->Location = System::Drawing::Point(16, 155);
			this->GroupBox3->Name = L"GroupBox3";
			this->GroupBox3->Size = System::Drawing::Size(400, 56);
			this->GroupBox3->TabIndex = 14;
			this->GroupBox3->TabStop = false;
			this->GroupBox3->Text = L"DAC Set";
			// 
			// DAC_DATA
			// 
			this->DAC_DATA->AcceptsReturn = true;
			this->DAC_DATA->BackColor = System::Drawing::SystemColors::Window;
			this->DAC_DATA->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->DAC_DATA->ForeColor = System::Drawing::SystemColors::WindowText;
			this->DAC_DATA->Location = System::Drawing::Point(144, 24);
			this->DAC_DATA->MaxLength = 0;
			this->DAC_DATA->Name = L"DAC_DATA";
			this->DAC_DATA->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->DAC_DATA->Size = System::Drawing::Size(73, 19);
			this->DAC_DATA->TabIndex = 41;
			this->DAC_DATA->Text = L"0";
			this->DAC_DATA->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			// 
			// DacConvert
			// 
			this->DacConvert->BackColor = System::Drawing::SystemColors::Control;
			this->DacConvert->Cursor = System::Windows::Forms::Cursors::Default;
			this->DacConvert->ForeColor = System::Drawing::SystemColors::ControlText;
			this->DacConvert->Location = System::Drawing::Point(32, 24);
			this->DacConvert->Name = L"DacConvert";
			this->DacConvert->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->DacConvert->Size = System::Drawing::Size(89, 25);
			this->DacConvert->TabIndex = 39;
			this->DacConvert->Text = L"Convert";
			this->DacConvert->UseVisualStyleBackColor = false;
			this->DacConvert->Click += gcnew System::EventHandler(this, &DevForm::DacConvert_Click);
			// 
			// Label13
			// 
			this->Label13->BackColor = System::Drawing::SystemColors::Control;
			this->Label13->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label13->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label13->Location = System::Drawing::Point(272, 24);
			this->Label13->Name = L"Label13";
			this->Label13->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label13->Size = System::Drawing::Size(89, 17);
			this->Label13->TabIndex = 42;
			this->Label13->Text = L"-2.5`2.5[V]";
			// 
			// Label5
			// 
			this->Label5->BackColor = System::Drawing::SystemColors::Control;
			this->Label5->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label5->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label5->Location = System::Drawing::Point(140, 16);
			this->Label5->Name = L"Label5";
			this->Label5->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label5->Size = System::Drawing::Size(49, 17);
			this->Label5->TabIndex = 18;
			this->Label5->Text = L"Request";
			// 
			// OFFSET
			// 
			this->OFFSET->AcceptsReturn = true;
			this->OFFSET->BackColor = System::Drawing::SystemColors::Window;
			this->OFFSET->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->OFFSET->ForeColor = System::Drawing::SystemColors::WindowText;
			this->OFFSET->Location = System::Drawing::Point(100, 88);
			this->OFFSET->MaxLength = 0;
			this->OFFSET->Name = L"OFFSET";
			this->OFFSET->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->OFFSET->Size = System::Drawing::Size(73, 19);
			this->OFFSET->TabIndex = 62;
			this->OFFSET->Text = L"0";
			this->OFFSET->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			// 
			// Label4
			// 
			this->Label4->BackColor = System::Drawing::SystemColors::Control;
			this->Label4->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label4->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label4->Location = System::Drawing::Point(356, 16);
			this->Label4->Name = L"Label4";
			this->Label4->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label4->Size = System::Drawing::Size(24, 17);
			this->Label4->TabIndex = 17;
			this->Label4->Text = L"nS";
			// 
			// Label3
			// 
			this->Label3->BackColor = System::Drawing::SystemColors::Control;
			this->Label3->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label3->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label3->Location = System::Drawing::Point(356, 40);
			this->Label3->Name = L"Label3";
			this->Label3->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label3->Size = System::Drawing::Size(25, 17);
			this->Label3->TabIndex = 16;
			this->Label3->Text = L"nS";
			// 
			// ExtClockDisp
			// 
			this->ExtClockDisp->BackColor = System::Drawing::SystemColors::Control;
			this->ExtClockDisp->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
			this->ExtClockDisp->Cursor = System::Windows::Forms::Cursors::Default;
			this->ExtClockDisp->ForeColor = System::Drawing::SystemColors::ControlText;
			this->ExtClockDisp->Location = System::Drawing::Point(212, 40);
			this->ExtClockDisp->Name = L"ExtClockDisp";
			this->ExtClockDisp->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->ExtClockDisp->Size = System::Drawing::Size(129, 17);
			this->ExtClockDisp->TabIndex = 14;
			this->ExtClockDisp->TextAlign = System::Drawing::ContentAlignment::TopRight;
			// 
			// GroupBox2
			// 
			this->GroupBox2->Controls->Add(this->ClockOut);
			this->GroupBox2->Controls->Add(this->ExtClock);
			this->GroupBox2->Controls->Add(this->Label6);
			this->GroupBox2->Controls->Add(this->Label5);
			this->GroupBox2->Controls->Add(this->Label4);
			this->GroupBox2->Controls->Add(this->Label3);
			this->GroupBox2->Controls->Add(this->ExtClockDisp);
			this->GroupBox2->Location = System::Drawing::Point(16, 75);
			this->GroupBox2->Name = L"GroupBox2";
			this->GroupBox2->Size = System::Drawing::Size(400, 72);
			this->GroupBox2->TabIndex = 13;
			this->GroupBox2->TabStop = false;
			this->GroupBox2->Text = L"Clock Output";
			// 
			// DATA_LENG
			// 
			this->DATA_LENG->AcceptsReturn = true;
			this->DATA_LENG->BackColor = System::Drawing::SystemColors::Window;
			this->DATA_LENG->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->DATA_LENG->ForeColor = System::Drawing::SystemColors::WindowText;
			this->DATA_LENG->Location = System::Drawing::Point(100, 120);
			this->DATA_LENG->MaxLength = 0;
			this->DATA_LENG->Name = L"DATA_LENG";
			this->DATA_LENG->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->DATA_LENG->Size = System::Drawing::Size(73, 19);
			this->DATA_LENG->TabIndex = 59;
			this->DATA_LENG->Text = L"1000";
			this->DATA_LENG->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			// 
			// AMPL
			// 
			this->AMPL->AcceptsReturn = true;
			this->AMPL->BackColor = System::Drawing::SystemColors::Window;
			this->AMPL->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->AMPL->ForeColor = System::Drawing::SystemColors::WindowText;
			this->AMPL->Location = System::Drawing::Point(100, 56);
			this->AMPL->MaxLength = 0;
			this->AMPL->Name = L"AMPL";
			this->AMPL->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->AMPL->Size = System::Drawing::Size(73, 19);
			this->AMPL->TabIndex = 56;
			this->AMPL->Text = L"5";
			this->AMPL->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			// 
			// IntClock
			// 
			this->IntClock->AcceptsReturn = true;
			this->IntClock->BackColor = System::Drawing::SystemColors::Window;
			this->IntClock->Cursor = System::Windows::Forms::Cursors::IBeam;
			this->IntClock->ForeColor = System::Drawing::SystemColors::WindowText;
			this->IntClock->Location = System::Drawing::Point(256, 152);
			this->IntClock->MaxLength = 0;
			this->IntClock->Name = L"IntClock";
			this->IntClock->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->IntClock->Size = System::Drawing::Size(104, 19);
			this->IntClock->TabIndex = 45;
			this->IntClock->Text = L"100000";
			this->IntClock->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			this->IntClock->TextChanged += gcnew System::EventHandler(this, &DevForm::IntClock_TextChanged);
			// 
			// SelIntClk
			// 
			this->SelIntClk->BackColor = System::Drawing::SystemColors::Control;
			this->SelIntClk->Cursor = System::Windows::Forms::Cursors::Default;
			this->SelIntClk->ForeColor = System::Drawing::SystemColors::ControlText;
			this->SelIntClk->Location = System::Drawing::Point(128, 152);
			this->SelIntClk->Name = L"SelIntClk";
			this->SelIntClk->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->SelIntClk->Size = System::Drawing::Size(65, 17);
			this->SelIntClk->TabIndex = 44;
			this->SelIntClk->TabStop = true;
			this->SelIntClk->Text = L"Internal";
			this->SelIntClk->UseVisualStyleBackColor = false;
			// 
			// SelExtClock
			// 
			this->SelExtClock->BackColor = System::Drawing::SystemColors::Control;
			this->SelExtClock->Cursor = System::Windows::Forms::Cursors::Default;
			this->SelExtClock->ForeColor = System::Drawing::SystemColors::ControlText;
			this->SelExtClock->Location = System::Drawing::Point(56, 152);
			this->SelExtClock->Name = L"SelExtClock";
			this->SelExtClock->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->SelExtClock->Size = System::Drawing::Size(65, 17);
			this->SelExtClock->TabIndex = 42;
			this->SelExtClock->TabStop = true;
			this->SelExtClock->Text = L"External";
			this->SelExtClock->UseVisualStyleBackColor = false;
			// 
			// DacStop
			// 
			this->DacStop->BackColor = System::Drawing::SystemColors::Control;
			this->DacStop->Cursor = System::Windows::Forms::Cursors::Default;
			this->DacStop->Enabled = false;
			this->DacStop->ForeColor = System::Drawing::SystemColors::ControlText;
			this->DacStop->Location = System::Drawing::Point(132, 216);
			this->DacStop->Name = L"DacStop";
			this->DacStop->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->DacStop->Size = System::Drawing::Size(89, 25);
			this->DacStop->TabIndex = 52;
			this->DacStop->Text = L"Stop";
			this->DacStop->UseVisualStyleBackColor = false;
			this->DacStop->Click += gcnew System::EventHandler(this, &DevForm::DacStop_Click);
			// 
			// Timer1
			// 
			this->Timer1->Enabled = true;
			this->Timer1->SynchronizingObject = this;
			this->Timer1->Elapsed += gcnew System::Timers::ElapsedEventHandler(this, &DevForm::Timer1_Elapsed);
			// 
			// WAVE_SHAPE
			// 
			this->WAVE_SHAPE->BackColor = System::Drawing::SystemColors::Window;
			this->WAVE_SHAPE->Cursor = System::Windows::Forms::Cursors::Default;
			this->WAVE_SHAPE->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->WAVE_SHAPE->ForeColor = System::Drawing::SystemColors::WindowText;
			this->WAVE_SHAPE->Items->AddRange(gcnew cli::array< System::Object^  >(3) {L"Sin", L"Rectangle", L"Square"});
			this->WAVE_SHAPE->Location = System::Drawing::Point(100, 24);
			this->WAVE_SHAPE->Name = L"WAVE_SHAPE";
			this->WAVE_SHAPE->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->WAVE_SHAPE->Size = System::Drawing::Size(113, 20);
			this->WAVE_SHAPE->TabIndex = 54;
			// 
			// DacStart
			// 
			this->DacStart->BackColor = System::Drawing::SystemColors::Control;
			this->DacStart->Cursor = System::Windows::Forms::Cursors::Default;
			this->DacStart->ForeColor = System::Drawing::SystemColors::ControlText;
			this->DacStart->Location = System::Drawing::Point(12, 216);
			this->DacStart->Name = L"DacStart";
			this->DacStart->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->DacStart->Size = System::Drawing::Size(89, 25);
			this->DacStart->TabIndex = 51;
			this->DacStart->Text = L"Start";
			this->DacStart->UseVisualStyleBackColor = false;
			this->DacStart->Click += gcnew System::EventHandler(this, &DevForm::DacStart_Click);
			// 
			// Label12
			// 
			this->Label12->BackColor = System::Drawing::SystemColors::Control;
			this->Label12->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label12->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label12->Location = System::Drawing::Point(12, 88);
			this->Label12->Name = L"Label12";
			this->Label12->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label12->Size = System::Drawing::Size(57, 17);
			this->Label12->TabIndex = 61;
			this->Label12->Text = L"Offset";
			// 
			// Label14
			// 
			this->Label14->BackColor = System::Drawing::SystemColors::Control;
			this->Label14->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label14->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label14->Location = System::Drawing::Point(188, 120);
			this->Label14->Name = L"Label14";
			this->Label14->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label14->Size = System::Drawing::Size(49, 17);
			this->Label14->TabIndex = 60;
			this->Label14->Text = L"1`4096";
			// 
			// Label10
			// 
			this->Label10->BackColor = System::Drawing::SystemColors::Control;
			this->Label10->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label10->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label10->Location = System::Drawing::Point(12, 120);
			this->Label10->Name = L"Label10";
			this->Label10->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label10->Size = System::Drawing::Size(73, 17);
			this->Label10->TabIndex = 58;
			this->Label10->Text = L"DataLength";
			// 
			// Label9
			// 
			this->Label9->BackColor = System::Drawing::SystemColors::Control;
			this->Label9->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label9->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label9->Location = System::Drawing::Point(180, 56);
			this->Label9->Name = L"Label9";
			this->Label9->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label9->Size = System::Drawing::Size(25, 17);
			this->Label9->TabIndex = 57;
			this->Label9->Text = L"[V]";
			// 
			// Label8
			// 
			this->Label8->BackColor = System::Drawing::SystemColors::Control;
			this->Label8->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label8->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label8->Location = System::Drawing::Point(12, 56);
			this->Label8->Name = L"Label8";
			this->Label8->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label8->Size = System::Drawing::Size(88, 17);
			this->Label8->TabIndex = 55;
			this->Label8->Text = L"Amplitude(p-p)";
			// 
			// Label7
			// 
			this->Label7->BackColor = System::Drawing::SystemColors::Control;
			this->Label7->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label7->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label7->Location = System::Drawing::Point(12, 24);
			this->Label7->Name = L"Label7";
			this->Label7->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label7->Size = System::Drawing::Size(41, 17);
			this->Label7->TabIndex = 53;
			this->Label7->Text = L"Shape";
			// 
			// IntClockDisp
			// 
			this->IntClockDisp->BackColor = System::Drawing::SystemColors::Control;
			this->IntClockDisp->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
			this->IntClockDisp->Cursor = System::Windows::Forms::Cursors::Default;
			this->IntClockDisp->ForeColor = System::Drawing::SystemColors::ControlText;
			this->IntClockDisp->Location = System::Drawing::Point(256, 176);
			this->IntClockDisp->Name = L"IntClockDisp";
			this->IntClockDisp->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->IntClockDisp->Size = System::Drawing::Size(104, 17);
			this->IntClockDisp->TabIndex = 50;
			this->IntClockDisp->TextAlign = System::Drawing::ContentAlignment::TopRight;
			// 
			// Label22
			// 
			this->Label22->BackColor = System::Drawing::SystemColors::Control;
			this->Label22->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label22->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label22->Location = System::Drawing::Point(372, 176);
			this->Label22->Name = L"Label22";
			this->Label22->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label22->Size = System::Drawing::Size(20, 17);
			this->Label22->TabIndex = 49;
			this->Label22->Text = L"nS";
			// 
			// Label21
			// 
			this->Label21->BackColor = System::Drawing::SystemColors::Control;
			this->Label21->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label21->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label21->Location = System::Drawing::Point(200, 176);
			this->Label21->Name = L"Label21";
			this->Label21->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label21->Size = System::Drawing::Size(41, 17);
			this->Label21->TabIndex = 48;
			this->Label21->Text = L"Actual";
			// 
			// Label20
			// 
			this->Label20->BackColor = System::Drawing::SystemColors::Control;
			this->Label20->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label20->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label20->Location = System::Drawing::Point(200, 152);
			this->Label20->Name = L"Label20";
			this->Label20->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label20->Size = System::Drawing::Size(49, 17);
			this->Label20->TabIndex = 47;
			this->Label20->Text = L"Request";
			// 
			// GroupBox4
			// 
			this->GroupBox4->Controls->Add(this->OFFSET);
			this->GroupBox4->Controls->Add(this->DATA_LENG);
			this->GroupBox4->Controls->Add(this->AMPL);
			this->GroupBox4->Controls->Add(this->WAVE_SHAPE);
			this->GroupBox4->Controls->Add(this->DacStop);
			this->GroupBox4->Controls->Add(this->DacStart);
			this->GroupBox4->Controls->Add(this->IntClock);
			this->GroupBox4->Controls->Add(this->SelIntClk);
			this->GroupBox4->Controls->Add(this->SelExtClock);
			this->GroupBox4->Controls->Add(this->Label12);
			this->GroupBox4->Controls->Add(this->Label14);
			this->GroupBox4->Controls->Add(this->Label10);
			this->GroupBox4->Controls->Add(this->Label9);
			this->GroupBox4->Controls->Add(this->Label8);
			this->GroupBox4->Controls->Add(this->Label7);
			this->GroupBox4->Controls->Add(this->IntClockDisp);
			this->GroupBox4->Controls->Add(this->Label22);
			this->GroupBox4->Controls->Add(this->Label21);
			this->GroupBox4->Controls->Add(this->Label20);
			this->GroupBox4->Controls->Add(this->Label19);
			this->GroupBox4->Controls->Add(this->Label18);
			this->GroupBox4->Location = System::Drawing::Point(16, 219);
			this->GroupBox4->Name = L"GroupBox4";
			this->GroupBox4->Size = System::Drawing::Size(400, 256);
			this->GroupBox4->TabIndex = 15;
			this->GroupBox4->TabStop = false;
			this->GroupBox4->Text = L"Wave Generator";
			// 
			// Label19
			// 
			this->Label19->BackColor = System::Drawing::SystemColors::Control;
			this->Label19->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label19->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label19->Location = System::Drawing::Point(372, 152);
			this->Label19->Name = L"Label19";
			this->Label19->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label19->Size = System::Drawing::Size(20, 17);
			this->Label19->TabIndex = 46;
			this->Label19->Text = L"nS";
			// 
			// Label18
			// 
			this->Label18->BackColor = System::Drawing::SystemColors::Control;
			this->Label18->Cursor = System::Windows::Forms::Cursors::Default;
			this->Label18->ForeColor = System::Drawing::SystemColors::ControlText;
			this->Label18->Location = System::Drawing::Point(12, 152);
			this->Label18->Name = L"Label18";
			this->Label18->RightToLeft = System::Windows::Forms::RightToLeft::No;
			this->Label18->Size = System::Drawing::Size(33, 17);
			this->Label18->TabIndex = 43;
			this->Label18->Text = L"Clock";
			// 
			// DevForm
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(432, 486);
			this->Controls->Add(this->GroupBox1);
			this->Controls->Add(this->GroupBox3);
			this->Controls->Add(this->GroupBox2);
			this->Controls->Add(this->GroupBox4);
			this->Name = L"DevForm";
			this->Text = L"DevForm";
			this->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &DevForm::DevForm_FormClosed);
			this->VisibleChanged += gcnew System::EventHandler(this, &DevForm::DevForm_VisibleChanged);
			this->GroupBox1->ResumeLayout(false);
			this->GroupBox3->ResumeLayout(false);
			this->GroupBox3->PerformLayout();
			this->GroupBox2->ResumeLayout(false);
			this->GroupBox2->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->Timer1))->EndInit();
			this->GroupBox4->ResumeLayout(false);
			this->GroupBox4->PerformLayout();
			this->ResumeLayout(false);

		}
#pragma endregion
public: void SetId(short Id)
		{
			short retErr;

			DevId = Id;

			this->Text = "ID = " + DevId.ToString() + "  Panel";
			pin_ptr<unsigned char> ptr = &IOStatus[0];
			retErr = TUSBK01DA_DIO_Status(DevId, ptr);
			ptr = nullptr;
			if( retErr != 0 )
			{
				MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
				this->Hide();
				return;
			}
			else
			{
				IOSEL1->SelectedIndex = IOStatus[0];
				IOSEL2->SelectedIndex = IOStatus[1];
			}

			ExtClock->Text = "1000";
			ExtClockValueCheck();
			IntClockValueCheck();
			SelIntClk->Checked = true;
			Timer1->Interval = 100;
			Timer1->Enabled = true;
			WAVE_SHAPE->SelectedIndex = 0;
		}
private: System::Void DevForm_FormClosed(System::Object^  sender, System::Windows::Forms::FormClosedEventArgs^  e) {
				 Timer1->Enabled = false;
		 }
private: System::Void DevForm_VisibleChanged(System::Object^  sender, System::EventArgs^  e) {
			 if( this->Visible == false )
				 Timer1->Enabled = false;
		 }
        // Enable Disable change of controls
private: void EnableDisableCont(Boolean StartStop)
        {
            if (StartStop) //Start ( on data recording )
            {
                DacStop->Enabled = true;
                DacStart->Enabled = false;
                SelExtClock->Enabled = false;
                SelIntClk->Enabled = false;
                WAVE_SHAPE->Enabled = false;
                AMPL->Enabled = false;
                OFFSET->Enabled = false;
                DATA_LENG->Enabled = false;
            }
            else
            {
                DacStop->Enabled = false;
                DacStart->Enabled = true;
                SelExtClock->Enabled = true;
                SelIntClk->Enabled = true;
                WAVE_SHAPE->Enabled = true;
                AMPL->Enabled = true;
                OFFSET->Enabled = true;
                DATA_LENG->Enabled = true;
            }
        }
        //Digital Port Direction Change
private: void SetDir(unsigned char b)
        {
            unsigned char Direction;
            short retErr;

            if (IOStatus[b] != 0)
                Direction = 1;
            else
                Direction = 0;

            retErr = TUSBK01DA_DIO_Dir(DevId, b, Direction);

            if (retErr != 0)
                MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
        }

        //
private: void SetDio(unsigned char b)
        {
            unsigned char data;
            short retErr;

            if (IOStatus[b] == 2)
                data = 1;
            else
                data = 0;

            retErr = TUSBK01DA_DIO_Out(DevId, b, data);
            if( retErr != 0 )
                MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
        }

private: System::Void IOSEL1_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
            switch (IOSEL1->SelectedIndex)
            {
                case 0://input
                    IOStatus[0] = (unsigned char) IOSEL1->SelectedIndex;
                    SetDir(0);
                    break;
                case 1://output low
                    IOStatus[0] = (unsigned char) IOSEL1->SelectedIndex;
                    SetDio(0);
                    SetDir(0);
                    break;
                case 2://output high
                    IOStatus[0] = (unsigned char) IOSEL1->SelectedIndex;
                    SetDio(0);
                    SetDir(0);
                    break;
            }
		 }
private: System::Void IOSEL2_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
            short retErr;

            switch (IOSEL2->SelectedIndex)
            {
                case 0: //input
                    IOStatus[1] = (unsigned char) IOSEL2->SelectedIndex;
                    SetDir(1);
                    break;
                case 1://output low
                    IOStatus[1] = (unsigned char) IOSEL2->SelectedIndex;
                    SetDio(1);
                    SetDir(1);
                    break;
                case 2://output high
                    IOStatus[1] = (unsigned char)IOSEL2->SelectedIndex;
                    SetDio(1);
                    SetDir(1);
                    break;
                case 3://clock
					pin_ptr <unsigned char> ptr = &IOStatus[0];
                    retErr = TUSBK01DA_DIO_Status(DevId, ptr);
					ptr = nullptr;
                    if (retErr != 0)
                    {
                        MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
                        this->Hide();
                        return;
                    }
                    else if (IOStatus[1] != 3)
                        IOSEL2->SelectedIndex = IOStatus[1];
                    break;
            }
		 }
private: void DIO_Check()
        {
            unsigned char data;
            short retErr;

            retErr = TUSBK01DA_DIO_In(DevId, &data);
            if (retErr != 0)
            {
                MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
                this->Hide();
                return;
            }
            D0State->Text = ((data & 0x1) != 0 )? "High" : "Low";
            D1State->Text = ((data & 0x2) != 0) ? "High" : "Low";
        }
private: System::Void ClockOut_Click(System::Object^  sender, System::EventArgs^  e) {
            int Clock;
            short retErr;

            if (int::TryParse(ExtClock->Text, Clock))
            {
                if (Clock < 1000 || Clock > 500000000)
                    MessageBox::Show("Cycle is outside the range.");
                else
                {
                    retErr = TUSBK01DA_ExtTimer_Set(DevId, Clock);
                    if (retErr != 0)
                        MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));
                    else
                        IOSEL2->SelectedIndex = 3;
                }
            }
            else
                MessageBox::Show("An input value is invalid.");
		 }
        // Ext Clock Value Check
private: void ExtClockValueCheck()
        {
            int tmpInt;
            if (ExtClockDisp->Text->Length >= 10)
                ExtClockDisp->Text = "";
            else if (int::TryParse(ExtClock->Text, tmpInt))
                ExtClockDisp->Text = TUSBK01DA_ExtTimer(tmpInt).ToString("N0");
            else
                ExtClockDisp->Text = "";
        }
private: System::Void ExtClock_TextChanged(System::Object^  sender, System::EventArgs^  e) {
			 ExtClockValueCheck();
		 }
		 // DAC Digital -> Analog Convert
private: System::Void DacConvert_Click(System::Object^  sender, System::EventArgs^  e) {
            short retErr;
            double Voltage;
            short iDigit;

            if( double::TryParse(DAC_DATA->Text,Voltage) )
            {
                if( Voltage < -2.5 || Voltage > 2.5 )
                {
                    MessageBox::Show("͒lsł");
                    return;
                }
            }
            else
            {
                MessageBox::Show("͒lsł");
                return;
            }

            iDigit = (short)(Voltage / 2.5 * 8192); //Convert Voltage -> Integer
            if (iDigit < -8192)
                iDigit = -8192;
            else if (iDigit > 8191)
                iDigit = 8191;

            retErr = TUSBK01DA_DacOut(DevId, iDigit);
            if (retErr != 0)
                MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));

            if( DacStop->Enabled )
                EnableDisableCont(false);
		 }
private: void IntClockValueCheck()
        {
            int tmpInt;

            if (IntClock->Text->Length < 11)
            {
                if (int::TryParse(IntClock->Text, tmpInt))
                    IntClockDisp->Text = TUSBK01DA_IntClk(tmpInt).ToString("N0");
                else
                    IntClockDisp->Text = "";
            }
            else
                IntClockDisp->Text = "";
        }
private: System::Void IntClock_TextChanged(System::Object^  sender, System::EventArgs^  e) {
			 IntClockValueCheck();
		 }
        //`g
private: double RectangleF(double Arg)
        {
            Arg /= (2.0 * Math::PI);//XP[2Pi->1ϊ
            Arg -= Math::Floor(Arg);//ng`ɕϊ
            if (Arg < 0.5)
                return 1.0;
            else
                return -1.0;
        }
        //Opg
private: double TriangleF(double Arg)
        {
            Arg /= (2.0 * Math::PI); //XP[2Pi->1ϊ
            Arg -= Math::Floor(Arg); //ng`ɕϊ
            Arg *= 4.0; //XP[1 -> 4ϊ
            if( Arg < 1.0 )
                return Arg;
            else if( Arg < 3.0 )
                return (2.0 - Arg);
            else
                return (Arg - 4.0);
        }
        //g`
private: void MakeShape(double data[], short Shape, int Leng, double Amp, double OFFSET)
        {
            int cnt;
            double angle;

            for (cnt = 0; cnt < Leng; cnt++)
            {
                angle = 2.0 * Math::PI * (double)cnt / (double)Leng;
                switch (Shape)
                {
                    case 0://g
                        data[cnt] = Amp * System::Math::Sin(angle) + OFFSET;
                        break;
                    case 1://Opg
                        data[cnt] = Amp * TriangleF(angle) + OFFSET;
                        break;
                    case 2://`g
                        data[cnt] = Amp * RectangleF(angle) + OFFSET;
                        break;
                    default:
                        data[cnt] = 0;
                        break;
                }
            }
        }
private: System::Void DacStart_Click(System::Object^  sender, System::EventArgs^  e) {
            short prm_DataLeng;
            double prm_Ampl;
            double prm_Offset;
            int prm_IntClock;
            double DataD[4095];
            short DataI[4095];
            int cnt;

            //ݒl`FbN
            if (short::TryParse(DATA_LENG->Text, prm_DataLeng) == false)
            {
                MessageBox::Show("DataLengthݒɌ肪܂");
                return;
            }

            if (double::TryParse(AMPL->Text, prm_Ampl ) == false)
            {
                MessageBox::Show("AmplitudeݒɌ肪܂");
                return;
            }

            if (double::TryParse(OFFSET->Text, prm_Offset) == false)
            {
                MessageBox::Show("OffsetݒɌ肪܂");
                return;
            }

            if (SelIntClk->Checked)
            {
                if (int::TryParse(IntClock->Text, prm_IntClock) == false)
                {
                    MessageBox::Show("IntClockݒɌ肪܂");
                    return;
                }
            }
            else
                prm_IntClock = 0;

            // g`
            MakeShape(DataD, (short) WAVE_SHAPE->SelectedIndex, prm_DataLeng, prm_Ampl / 2.0, prm_Offset);

            //(DACR[h)
            for (cnt = 0; cnt < prm_DataLeng; cnt++)
            {
                DataI[cnt] = (short) ( DataD[cnt] * 8192.0 / 2.5 );
                if (DataI[cnt] >= 8191)
                    DataI[cnt] = 8191;
                else if (DataI[cnt] <= -8192)
                    DataI[cnt] = -8192;
            }

            //f[^ݒ
            TUSBK01DA_Data_Set(DevId, DataI,  prm_DataLeng);

            //Jn
            if (SelExtClock->Checked)
                TUSBK01DA_Da_Start(DevId, 0, prm_DataLeng);
            else
                TUSBK01DA_Da_Start(DevId, prm_IntClock, prm_DataLeng);

            EnableDisableCont(true);
		 }
private: System::Void DacStop_Click(System::Object^  sender, System::EventArgs^  e) {
            short retErr;

            retErr = TUSBK01DA_Da_Stop(DevId);
            if (retErr != 0)
                MessageBox::Show(TUSBK01DA_GetErrMessage(retErr));

            EnableDisableCont(false);
		 }
private: System::Void Timer1_Elapsed(System::Object^  sender, System::Timers::ElapsedEventArgs^  e) {
            Timer1->Enabled = false;
            if (this->Visible == false)
                return;
            else
            {
                DIO_Check();
                Timer1->Enabled = true;
            }
		 }
};
}
