﻿//-----------------------------------------------
//TUSB-K01DA用ドライバアクセス用API
//Visual C# 用モジュール
//
//2014_1_16　株式会社タートル工業
//Copyright (C) 2014 Turtle Industry Co.,Ltd.
//-----------------------------------------------

using System.Runtime.InteropServices;


class TUSBKDA
{
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_Device_Open(short Id);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern void TUSBK01DA_Device_Close(short Id);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_DacOut(short Id, short data);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern double TUSBK01DA_IntClk(int clk);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_Da_Start(short Id, int clk, short dLen);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_Da_Stop(short Id);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_Da_Status(short Id, out byte Status);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_Data_Set(short Id, [In] short[] data,short Leng);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern double TUSBK01DA_ExtTimer(int clk);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_ExtTimer_Set(short Id, int clk);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_DIO_Dir(short Id, byte b, byte direction);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_DIO_Out(short Id, byte b, byte data);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_DIO_In(short Id, out byte data);
    [DllImport("TUSBKDA.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short TUSBK01DA_DIO_Status(short Id, [Out] byte[] data);
    public static string GetErrMessage(short retcode)
    {
        switch (retcode)
        {
            case 0:
                return "正常終了しました";
            case 1:
                return "ID番号が不正です";
            case 2:
                return "ドライバがインストールされていません";
            case 3:
                return "すでにデバイスはオープンされています";
            case 4:
                return "接続されている台数が多すぎます";
            case 5:
                return "オープンできませんでした";
            case 6:
                return "デバイスがみつかりません";
            case 8:
                return "パラメータエラー";
            case 9:
                return "USB通信エラーです";
            default:
                return "不明なエラーです";
        }
    }
}


