﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace K01DASample
{
    public partial class Form1 : Form
    {
        private Boolean[] DevStatus = new Boolean[16];// Device Connection Flag TRUE : connecting
        private DevForm[] IdDevForm = new DevForm[16];// Device Control Panel Form Object
        public Form1()
        {
            InitializeComponent();
        }

        // Main Form Load
        private void Form1_Load(object sender, EventArgs e)
        {
            short DevId;

            Timer1.Interval = 300;
            Timer1.Enabled = true;

            DevIdSel.SelectedIndex = 0;

            //Initialize
            for (DevId = 0; DevId < 16; DevId++)
            {
                DevStatus[DevId] = false;//Device is not Connected
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            short DevId;

            Timer1.Enabled = false;
            for (DevId = 0; DevId < 16; DevId++)
            {
                if (IdDevForm[DevId] != null)
                {
                    if (IdDevForm[DevId].Visible)
                    {
                        IdDevForm[DevId].Close();
                        DevStatus[DevId] = false;
                        TUSBKDA.TUSBK01DA_Device_Close(DevId);
                    }
                }
            }
        }

        // Device Control Panel Open
        private void OpenPanel(short Id)
        {
            DevStatus[Id] = true;
            IdDevForm[Id] = new DevForm();//Device Control Panel Form Create
            IdDevForm[Id].SetId(Id);
            IdDevForm[Id].Show();//Form Show

        }

        private void OpenBtn_Click(object sender, EventArgs e)
        {
            short DevId;
            short retErr;

            DevId = (short)DevIdSel.SelectedIndex;
            if (DevStatus[DevId] == false)// Device is not connected
            {
                retErr = TUSBKDA.TUSBK01DA_Device_Open(DevId);
                if (retErr != 0)
                    MessageBox.Show(TUSBKDA.GetErrMessage(retErr));
                else
                    OpenPanel(DevId);
            }
        }

        private void Timer1_Tick(object sender, EventArgs e)
        {
            short DevId;

            for (DevId = 0; DevId < 16; DevId++)
            {
                if (DevStatus[DevId])
                {
                    if (IdDevForm[DevId].Visible == false)//Device is not visible
                    {
                        TUSBKDA.TUSBK01DA_Device_Close(DevId);
                        DevStatus[DevId] = false;
                    }
                }
            }
        }

        private void EndBtn_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
