﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace S03CN2Sample
{
    public partial class Form1 : Form
    {
        const short DevId = 0; //デバイスIDは0固定
        

        //コントロールの配列
        //この配列を通してコントロールを使用します。
        private System.Windows.Forms.Label[] ArryCntDisp;
        private System.Windows.Forms.RadioButton[] ArryOptFreq;
        private System.Windows.Forms.RadioButton[] ArryOptPeriod;
        private System.Windows.Forms.ComboBox[] ArrySelGateTime;
        private System.Windows.Forms.ComboBox[] ArrySelEdgeDir;
        private System.Windows.Forms.ComboBox[] ArrySelClock;
        private System.Windows.Forms.ComboBox[] ArrySelDivide;

        public Form1()
        {
            InitializeComponent();
        }

        private void SettingInit()
        {
            short retcode;
            int ch;

            //コントロールの配列に画面のコントロールを設定します
            ArryCntDisp = new System.Windows.Forms.Label[] {CntDisp1,CntDisp2,CntDisp3};
            ArryOptFreq = new System.Windows.Forms.RadioButton[] {OptFreq1, OptFreq2, OptFreq3};
            ArryOptPeriod = new System.Windows.Forms.RadioButton[] {OptPeriod1, OptPeriod2, OptPeriod3};
            ArrySelGateTime = new System.Windows.Forms.ComboBox[] {SelGateTime1, SelGateTime2, SelGateTime3};
            ArrySelEdgeDir = new System.Windows.Forms.ComboBox[] {SelEdgeDir1, SelEdgeDir2, SelEdgeDir3};
            ArrySelClock = new System.Windows.Forms.ComboBox[] {SelClock1, SelClock2, SelClock3};
            ArrySelDivide = new System.Windows.Forms.ComboBox[] { SelDivide1, SelDivide2, SelDivide3 };

            for (ch = 0; ch < 3; ch++)
            {
                //各コントロールのTagにchを設定して後で操作に使用します
                ArryOptFreq[ch].Tag = (byte) ch;
                ArryOptPeriod[ch].Tag = (byte) ch;
                ArrySelGateTime[ch].Tag = (byte) ch;
                ArrySelEdgeDir[ch].Tag = (byte) ch;
                ArrySelClock[ch].Tag = (byte) ch;
                ArrySelDivide[ch].Tag = (byte) ch;

                //各コントロールに値を設定初期化します
                ArryOptFreq[ch].Checked = true;// 周波数モード
                ArrySelGateTime[ch].SelectedIndex = 0;// 10msゲート
                ArrySelEdgeDir[ch].SelectedIndex = 0;// 立上りエッジ
                ArrySelClock[ch].SelectedIndex = 0;// 100nsクロック
                ArrySelDivide[ch].SelectedIndex = 0;// 分周期1/1

                if((retcode = Tusbs03cn2.Tusbs03cn2_Counter_Mode(DevId, (byte)ch, 1)) != 0)
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                if((retcode = Tusbs03cn2.Tusbs03cn2_Gate_Time(DevId, (byte) ch, (byte) ArrySelGateTime[ch].SelectedIndex)) != 0)
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                if((retcode = Tusbs03cn2.Tusbs03cn2_Cnt_Clock_Set(DevId, (byte) ch, (byte) ArrySelClock[ch].SelectedIndex)) != 0 )
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                if((retcode = Tusbs03cn2.Tusbs03cn2_Divider_Set(DevId, (byte) ch, (byte) ArrySelDivide[ch].SelectedIndex)) != 0 )
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                if((retcode = Tusbs03cn2.Tusbs03cn2_Ext_Input_Set(DevId, (byte) ch, (byte) ArrySelEdgeDir[ch].SelectedIndex)) != 0 )
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            short retcode;

           //デバイスオープン
            try
            {
                if ((retcode = Tusbs03cn2.Tusbs03cn2_Device_Open(DevId)) != 0)
                {
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                    this.Close();
                }
                else
                {
                    SettingInit();//初期設定
                    Timer1.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                this.Close();
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Tusbs03cn2.Tusbs03cn2_Device_Close(DevId);//デバイスクローズ
        }

        private void OptFreq_CheckedChanged(object sender, EventArgs e)
        {
            short retcode;
            RadioButton tmpControl = (RadioButton)sender;
            if (tmpControl.Checked)
            {
                if ((retcode = Tusbs03cn2.Tusbs03cn2_Counter_Mode(DevId, (byte)(tmpControl.Tag), 1)) != 0)
                {
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                }
            }
        }

        private void OptPeriod_CheckedChanged(object sender, EventArgs e)
        {
            short retcode;
            RadioButton tmpControl = (RadioButton)sender;
            if( tmpControl.Checked)
            {
                if((retcode = Tusbs03cn2.Tusbs03cn2_Counter_Mode(DevId,(byte)(tmpControl.Tag),0)) != 0)
                {
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                }
            }
        }

        private void SelGateTime_SelectedIndexChanged(object sender, EventArgs e)
        {
            short retcode;
            ComboBox tmpControl = (ComboBox)sender;
            if ((retcode = Tusbs03cn2.Tusbs03cn2_Gate_Time(DevId, (byte)(tmpControl.Tag), (byte)(tmpControl.SelectedIndex))) != 0)
            {
                MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
            }
        }

        private void SelClock_SelectedIndexChanged(object sender, EventArgs e)
        {
            short retcode;
            ComboBox tmpControl = (ComboBox)sender;
            if ((retcode = Tusbs03cn2.Tusbs03cn2_Cnt_Clock_Set(DevId, (byte)(tmpControl.Tag), (byte)(tmpControl.SelectedIndex))) != 0)
            {
                MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
            }
        }

        private void SelDivide_SelectedIndexChanged(object sender, EventArgs e)
        {
            short retcode;
            ComboBox tmpControl = (ComboBox)sender;
            if ((retcode = Tusbs03cn2.Tusbs03cn2_Divider_Set(DevId, (byte)(tmpControl.Tag), (byte)(tmpControl.SelectedIndex))) != 0)
            {
                MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
            }
        }

        private void SelEdgeDir_SelectedIndexChanged(object sender, EventArgs e)
        {
            short retcode;
            ComboBox tmpControl = (ComboBox)sender;
            if ((retcode = Tusbs03cn2.Tusbs03cn2_Ext_Input_Set(DevId, (byte)(tmpControl.Tag), (byte)(tmpControl.SelectedIndex))) != 0)
            {
                MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
            }
        }

        private void Timer1_Tick(object sender, EventArgs e)
        {
            short retcode;
            int CountNum;//カウント値
            byte Valid;//有効フラグ
            byte ch;

            for(ch = 0; ch < 3 ; ch++ )
            {
                if((retcode = Tusbs03cn2.Tusbs03cn2_Counter_Read(DevId,ch,out CountNum,out Valid)) != 0 )
                {
                    MessageBox.Show(Tusbs03cn2.GetErrMessage(retcode));
                    Timer1.Enabled = false;
                    return;
                }
                
                if(Valid == 0)//読み込み値が無効ならば
                {
                    ArryCntDisp[ch].Text = "";
                }
                else//有効ならば
                {
                    ArryCntDisp[ch].Text = CountNum.ToString("d");
                }
            }
        }

    }
}
