﻿Option Strict On

Public Class Form1
    Const DevId As Short = 0 ' デバイスIDを0とする

    'コントロールの配列
    'この配列を通してコントロールを使用します。
    Private ArryCntDisp() As System.Windows.Forms.Label
    Private ArryOptFreq() As System.Windows.Forms.RadioButton
    Private ArryOptPeriod() As System.Windows.Forms.RadioButton
    Private ArrySelGateTime() As System.Windows.Forms.ComboBox
    Private ArrySelEdgeDir() As System.Windows.Forms.ComboBox
    Private ArrySelClock() As System.Windows.Forms.ComboBox
    Private ArrySelDivide() As System.Windows.Forms.ComboBox
    '設定の初期化
    Private Sub SettingInit()
        Dim retcode As Short
        Dim ch As Integer

        'コントロールの配列に画面のコントロールを設定します
        ArryCntDisp = New System.Windows.Forms.Label() {CntDisp1, CntDisp2, CntDisp3}
        ArryOptFreq = New System.Windows.Forms.RadioButton() {OptFreq1, OptFreq2, OptFreq3}
        ArryOptPeriod = New System.Windows.Forms.RadioButton() {OptPeriod1, OptPeriod2, OptPeriod3}
        ArrySelGateTime = New System.Windows.Forms.ComboBox() {SelGateTime1, SelGateTime2, SelGateTime3}
        ArrySelEdgeDir = New System.Windows.Forms.ComboBox() {SelEdgeDir1, SelEdgeDir2, SelEdgeDir3}
        ArrySelClock = New System.Windows.Forms.ComboBox() {SelClock1, SelClock2, SelClock3}
        ArrySelDivide = New System.Windows.Forms.ComboBox() {SelDivide1, SelDivide2, SelDivide3}

        For ch = 0 To 2
            '各コントロールのTagにchを設定して後で操作に使用します
            ArryOptFreq(ch).Tag = ch
            ArryOptPeriod(ch).Tag = ch
            ArrySelGateTime(ch).Tag = ch
            ArrySelEdgeDir(ch).Tag = ch
            ArrySelClock(ch).Tag = ch
            ArrySelDivide(ch).Tag = ch

            '各コントロールに値を設定初期化します
            ArryOptFreq(ch).Checked = True '周波数モード
            ArrySelGateTime(ch).SelectedIndex = 0 '10msゲート
            ArrySelEdgeDir(ch).SelectedIndex = 0 '立上りエッジ
            ArrySelClock(ch).SelectedIndex = 0 '100nsクロック
            ArrySelDivide(ch).SelectedIndex = 0 '分周期1/1

            retcode = Tusbs03cn2_Counter_Mode(DevId, CType(ch, Byte), 1)
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If

            retcode = Tusbs03cn2_Gate_Time(DevId, CType(ch, Byte), CType(ArrySelGateTime(ch).SelectedIndex, Byte))
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If

            retcode = Tusbs03cn2_Cnt_Clock_Set(DevId, CType(ch, Byte), CType(ArrySelClock(ch).SelectedIndex, Byte))
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If

            retcode = Tusbs03cn2_Divider_Set(DevId, CType(ch, Byte), CType(ArrySelDivide(ch).SelectedIndex, Byte))
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If

            retcode = Tusbs03cn2_Ext_Input_Set(DevId, CType(ch, Byte), CType(ArrySelEdgeDir(ch).SelectedIndex, Byte))
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If
        Next
    End Sub
    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim retcode As Short

        'デバイスオープン
        Try
            retcode = Tusbs03cn2_Device_Open(DevId)
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
                Me.Close()
            Else
                SettingInit() '初期設定
                Timer1.Enabled = True
            End If
        Catch ex As Exception
            MessageBox.Show(ex.Message)
            Me.Close()
        End Try
    End Sub

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Tusbs03cn2_Device_Close(DevId) 'デバイスクローズ
    End Sub

    Private Sub OptFreq_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles OptFreq1.CheckedChanged, OptFreq3.CheckedChanged, OptFreq2.CheckedChanged
        Dim retcode As Short
        Dim tmpControl As RadioButton = TryCast(sender, RadioButton)
        If tmpControl.Checked Then
            retcode = Tusbs03cn2_Counter_Mode(DevId, CType(tmpControl.Tag, Byte), 1)
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If
        End If
    End Sub

    Private Sub OptPeriod_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles OptPeriod1.CheckedChanged, OptPeriod3.CheckedChanged, OptPeriod2.CheckedChanged
        Dim retcode As Short
        Dim tmpControl As RadioButton = TryCast(sender, RadioButton)
        If tmpControl.Checked Then
            retcode = Tusbs03cn2_Counter_Mode(DevId, CType(tmpControl.Tag, Byte), 0)
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
            End If
        End If
    End Sub

    Private Sub SelGateTime_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles SelGateTime1.SelectedIndexChanged, SelGateTime3.SelectedIndexChanged, SelGateTime2.SelectedIndexChanged
        Dim retcode As Short
        Dim tmpControl As ComboBox = TryCast(sender, ComboBox)
        retcode = Tusbs03cn2_Gate_Time(DevId, CType(tmpControl.Tag, Byte), CType(tmpControl.SelectedIndex, Byte))
        If retcode <> 0 Then
            MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
        End If
    End Sub

    Private Sub SelClock_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles SelClock1.SelectedIndexChanged, SelClock3.SelectedIndexChanged, SelClock2.SelectedIndexChanged
        Dim retcode As Short
        Dim tmpControl As ComboBox = TryCast(sender, ComboBox)
        retcode = Tusbs03cn2_Cnt_Clock_Set(DevId, CType(tmpControl.Tag, Byte), CType(tmpControl.SelectedIndex, Byte))
        If retcode <> 0 Then
            MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
        End If
    End Sub

    Private Sub SelDivide_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles SelDivide1.SelectedIndexChanged, SelDivide3.SelectedIndexChanged, SelDivide2.SelectedIndexChanged
        Dim retcode As Short
        Dim tmpControl As ComboBox = TryCast(sender, ComboBox)
        retcode = Tusbs03cn2_Divider_Set(DevId, CType(tmpControl.Tag, Byte), CType(tmpControl.SelectedIndex, Byte))
        If retcode <> 0 Then
            MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
        End If
    End Sub

    Private Sub SelEdgeDir_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles SelEdgeDir1.SelectedIndexChanged, SelEdgeDir3.SelectedIndexChanged, SelEdgeDir2.SelectedIndexChanged
        Dim retcode As Short
        Dim tmpControl As ComboBox = TryCast(sender, ComboBox)
        retcode = Tusbs03cn2_Ext_Input_Set(DevId, CType(tmpControl.Tag, Byte), CType(tmpControl.SelectedIndex, Byte))
        If retcode <> 0 Then
            MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
        End If
    End Sub

    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        Dim retcode As Short
        Dim CountNum As Integer 'カウント値
        Dim Valid As Byte '有効フラグ
        Dim ch As Byte

        For ch = 0 To 2
            retcode = Tusbs03cn2_Counter_Read(DevId, ch, CountNum, Valid)
            If retcode <> 0 Then
                MessageBox.Show(Tusbs03cn2_GetErrMessage(retcode))
                Timer1.Enabled = False
                Exit Sub
            End If
            If Valid = 0 Then '読み込み値が無効ならば
                ArryCntDisp(ch).Text = ""
            Else '有効ならば
                ArryCntDisp(ch).Text = CountNum.ToString("d")
            End If
        Next
    End Sub
End Class
