﻿using System.Runtime.InteropServices;

class Tusbs03cn2
{
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Device_Open(short id);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern void Tusbs03cn2_Device_Close(short id);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Counter_Read(short id, byte ch, out int xData, out byte Valid);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Ext_Input_Set(short id, byte ch, byte UpDown);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Counter_Mode(short id, byte ch, byte mode);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Gate_Time(short id, byte ch, byte time);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Cnt_Clock_Set(short id, byte ch, byte clk);
    [DllImport("TUSBSCN2.DLL", CallingConvention = CallingConvention.Cdecl)]
    public static extern short Tusbs03cn2_Divider_Set(short id, byte ch, byte div);

    public static string GetErrMessage(short retcode)
    {
        switch (retcode)
        {
            case 0:
                return "正常終了しました";
            case 1:
                return "ID番号が不正です";
            case 2:
                return "ドライバがインストールされていません";
            case 3:
                return "すでにデバイスはオープンされています";
            case 4:
                return "接続されている台数が多すぎます";
            case 5:
                return "オープンできませんでした";
            case 6:
                return "デバイスがみつかりません";
            case 7:
                return "オープンされていません";
            case 8:
                return "パラメータエラー";
            case 9:
                return "USB通信エラーです";
            default:
                return "不明なエラーです";
        }
    }
}

