﻿Public Class MainForm1


    Private DevStatus(15) As Boolean ' Device Connection Flag TRUE : connecting
    Private IdDevForm(15) As KDIOForm ' Device Control Panel Form Object

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim DevId As Integer

        TUSBK16DIO_Load() 'Driver Load

        'Initialize
        For DevId = 0 To 15
            DevStatus(DevId) = False 'Device is not Connected
            IdDevForm(DevId) = New KDIOForm()   'Device Control Panel Form Create
        Next DevId

        ' Timer Start
        Timer1.Interval = 500
        Timer1.Enabled = True
    End Sub



    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Dim DevId As Integer

        Timer1.Enabled = False ' Timer Disable

        For DevId = 0 To 15
            IdDevForm(DevId) = Nothing ' Device Control Panel Unload
        Next DevId

        TUSBK16DIO_Unload() ' Driver Unload
    End Sub

    ' Device Control Panel Open
    Private Sub OpenPanel(ByVal Id As Short)
        IdDevForm(Id).Show() ' Form Show
        IdDevForm(Id).SetId(Id)
        DevStatus(Id) = True
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim DevId As Short

        For DevId = 0 To 15
            If DevStatus(DevId) = False Then ' Device is not connected
                If TUSBK16DIO_Chk(DevId) = 0 Then ' Connection check
                    OpenPanel(DevId) '
                End If
            Else 'Device is connected
                If IdDevForm(DevId).Visible = False Then ' Device is not visible
                    DevStatus(DevId) = False
                End If
            End If
        Next DevId
    End Sub


    ' Program End Command
    Private Sub EndBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles EndBtn.Click
        Me.Close()
    End Sub
End Class
