﻿Public Class KDIOForm
    Inherits System.Windows.Forms.Form

    Private DevId As Integer         'Device Id
    Private DOUTStatus(1) As Byte    'Digital Output Status
    'チェックボックスコントロール用配列を作成
    Private P1OUT() As System.Windows.Forms.CheckBox
    Private P2OUT() As System.Windows.Forms.CheckBox
    'ラベルコントロール用配列を作成
    Private P1ST() As System.Windows.Forms.Label
    Private P2ST() As System.Windows.Forms.Label


    'This Form module initialize
    Public Sub SetId(ByVal Id As Short)
        Dim retErr As Integer
        Dim Dir1 As Byte
        Dim Dir2 As Byte
        Dim Bit As Byte
        Dim Mask As Integer

        DevId = Id

        Me.Text = "ID = " + CStr(DevId) + "  Panel"

        retErr = TUSBK16DIO_DirRead(DevId, Dir1, Dir2)
        If retErr Then
            TUSBK02AD_ErrorDisp(retErr)
            Me.Close()
            Exit Sub
        End If


        If Dir2 Then
            P2IOSEL2.Checked = True '出力

        Else
            P2IOSEL1.Checked = True '入力

        End If

        retErr = TUSBK16DIO_OutputRead(DevId, DOUTStatus(0), DOUTStatus(1))
        If retErr Then
            TUSBK02AD_ErrorDisp(retErr)
            Me.Close()
            Exit Sub
        Else
            Mask = 1
            For Bit = 0 To 7
                If DOUTStatus(0) And Mask Then
                    P1OUT(Bit).Checked = True
                End If
                If DOUTStatus(1) And Mask Then
                    P2OUT(Bit).Checked = True
                End If
                Mask = Mask * 2
            Next Bit
        End If

        IoCheck()

        Timer1.Interval = 100
        Timer1.Enabled = True
    End Sub

    Private Sub KDIOForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Me.P2OUT = New System.Windows.Forms.CheckBox() _
            {Me.P2OUT0, Me.P2OUT1, Me.P2OUT2, Me.P2OUT3, _
            Me.P2OUT4, Me.P2OUT5, Me.P2OUT6, Me.P2OUT7}

        'ラベルコントロールのインスタンスを配列にコピーして配列化する
        Me.P1ST = New System.Windows.Forms.Label() _
            {Me.P1ST0, Me.P1ST1, Me.P1ST2, Me.P1ST3, _
            Me.P1ST4, Me.P1ST5, Me.P1ST6, Me.P1ST7}
        Me.P2ST = New System.Windows.Forms.Label() _
            {Me.P2ST0, Me.P2ST1, Me.P2ST2, Me.P2ST3, _
            Me.P2ST4, Me.P2ST5, Me.P2ST6, Me.P2ST7}
    End Sub

    Private Sub IoCheck()
        Dim retErr As Short
        Dim Data1 As Byte
        Dim Data2 As Byte
        Dim Bit As Short
        Dim Mask As Short

        'io状態読み取り
        retErr = TUSBK16DIO_Read(DevId, Data1, Data2)

        Mask = 1

        For Bit = 0 To 7
            If Data1 And Mask Then
                P1ST(Bit).Text = "High"
                P1ST(Bit).BackColor = Color.OrangeRed
            Else
                P1ST(Bit).Text = "Low"
                P1ST(Bit).BackColor = Color.LightSteelBlue
            End If

            If Data2 And Mask Then
                P2ST(Bit).Text = "High"
                P2ST(Bit).BackColor = Color.OrangeRed
            Else
                P2ST(Bit).Text = "Low"
                P2ST(Bit).BackColor = Color.LightSteelBlue

            End If

            Mask = Mask * 2
        Next Bit
    End Sub




    Private Sub P1OUT_Changed(ByVal index As Integer)
        Dim retErr As Short
        Dim tmpB As Byte

        tmpB = 2 ^ index

        If P1OUT(index).CheckState Then
            DOUTStatus(0) = DOUTStatus(0) Or tmpB
        Else
            DOUTStatus(0) = DOUTStatus(0) And (Not tmpB)
        End If

        retErr = TUSBK16DIO_PortWrite(DevId, 0, DOUTStatus(0))

        If retErr Then
            TUSBK02AD_ErrorDisp(retErr)
        End If
    End Sub



    Private Sub P2IOSEL1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2IOSEL1.CheckedChanged
        Dim retErr As Short

        If sender.Checked Then
            retErr = TUSBK16DIO_Dir(DevId, 1, 0)
            If retErr Then
                TUSBK02AD_ErrorDisp(retErr)
            End If
        End If


    End Sub


    Private Sub P2IOSEL2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2IOSEL2.CheckedChanged
        Dim retErr As Short

        If sender.Checked Then
            retErr = TUSBK16DIO_Dir(DevId, 1, 1)
            If retErr Then
                TUSBK02AD_ErrorDisp(retErr)
            End If
        End If
    End Sub


    Private Sub P2OUT_Changed(ByVal index As Integer)
        Dim retErr As Short
        Dim tmpB As Byte

        tmpB = 2 ^ index

        If P2OUT(index).CheckState Then
            DOUTStatus(1) = DOUTStatus(1) Or tmpB
        Else
            DOUTStatus(1) = DOUTStatus(1) And (Not tmpB)
        End If

        retErr = TUSBK16DIO_PortWrite(DevId, 1, DOUTStatus(1))

        If retErr Then
            TUSBK02AD_ErrorDisp(retErr)
        End If
    End Sub


    Private Sub P2OUT0_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT0.CheckedChanged
        P2OUT_Changed(0)
    End Sub

    Private Sub P2OUT1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT1.CheckedChanged
        P2OUT_Changed(1)
    End Sub

    Private Sub P2OUT2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT2.CheckedChanged
        P2OUT_Changed(2)
    End Sub

    Private Sub P2OUT3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT3.CheckedChanged
        P2OUT_Changed(3)
    End Sub

    Private Sub P2OUT4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT4.CheckedChanged
        P2OUT_Changed(4)
    End Sub

    Private Sub P2OUT5_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT5.CheckedChanged
        P2OUT_Changed(5)
    End Sub

    Private Sub P2OUT6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT6.CheckedChanged
        P2OUT_Changed(6)
    End Sub

    Private Sub P2OUT7_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles P2OUT7.CheckedChanged
        P2OUT_Changed(7)
    End Sub




    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If TUSBK16DIO_Chk(DevId) <> 0 Then
            Me.Hide()
            Exit Sub
        End If
        IoCheck()
    End Sub




    Private Sub HelpButton1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HelpButton1.Click
        MessageBox.Show("T-LEARN01のSW動作により、TUSB-K16DIOの入力がHigh/Lowに切り替わり、状態が表示されます", "Port1_Help", MessageBoxButtons.OK, MessageBoxIcon.Information)


    End Sub

    Private Sub HelpButton2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HelpButton2.Click
        Dim msg1 As String = "出力選択の場合：チェックボックスのチェック無しでTUSB-K16DIO"
        Dim msg2 As String = "　　　　　　　　の出力がLowとなりLEDが点灯します。チェック"
        Dim msg3 As String = "　　　　　　　　　有りの場合出力がHighでLEDが消灯します。"
        Dim kaigyo As String = vbCrLf
        Dim msg4 As String = "入力選択の場合：入力はHighとなります。"


        MessageBox.Show(msg1 + msg2 + msg3 + kaigyo + msg4, "Port2_Help", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub
End Class