#//-----------------------------------------------
#//TUSB-16DIF用Pythonサンプルプログラム
#// 処理関数等
#//
#//2024_05_07　株式会社タートル工業
#//Copyright (C) 2024 Turtle Industry Co.,Ltd.
#//-----------------------------------------------

import tkinter as tk
import tkinter.ttk as ttk
import threading
from tkinter import messagebox
import time

def ShowInfo(str):
    """文字列を表示する"""
    messagebox.showinfo("",str)

def IsBitSet(data,bit):
    if ((data>>bit) & 1) == 1:return True
    else:return False

def GetLabel(master,text,relx,rely):
    """ラベルを作成する
    
    arguments:
    master      ----    配置ペアレント
    text        ----    表示する文字列
    relx        ----    X座標相対位置(左端)
    rely        ----    Y座標相対位置(上下中央)

    returns:
    Label       ----    生成されたラベルインスタンス
    """
    label = tk.Label(master,text=text)
    label.place(relx=relx,rely=rely,anchor=tk.W)
    return label

def GetChkBoxCom(master,text,relx,rely,val,command=None):
    """チェックボックスを生成する イベントハンドラ設定付
    
    arguments:
    master      ----    配置ペアレント
    text        ----    表示する文字列
    relx        ----    X座標相対位置(左端)
    rely        ----    Y座標相対位置(上下中央)
    val         ----    variableを対応させるwidget変数(例 BooleanVar())
    command     ----    ボタンが押された時に呼び出されるハンドラ関数

    returns:
    Checkbutton ----    生成されたチェックボックスのインスタンス
    """
    chkbox = tk.Checkbutton(master,text=text,variable=val,command=command)
    chkbox.place(relx=relx,rely=rely,anchor=tk.W)
    return chkbox

def GetButton(master,text,command,relw,relx,rely):
    """ボタンを作成する
    
    arguments:
    master      ----    配置ペアレント
    text        ----    ボタンに表示する文字列
    command     ----    ボタンが押された時に呼び出されるハンドラ関数
    relw        ----    表示幅(相対値)
    relx        ----    X座標相対位置(左右中央)
    rely        ----    Y座標相対位置(上下中央)

    returns:
    Button      ----    生成されたボタンインスタンス
    """
    button = tk.Button(master,text=text,command=command)
    button.place(relwidth=relw,relx=relx,rely=rely,anchor=tk.CENTER)
    return button

def GetComboBox(master,value,relw,relx,rely,command=None):
    """コンボボックスを作成する
    
    arguments:
    master      ----    配置ペアレント
    value       ----    コンボボックスに設定するデータリスト(又はタプル)
    relw        ----    表示幅(相対値)
    relx        ----    X座標相対位置(左端)
    rely        ----    Y座標相対位置(上下中央)
    command     ----    選択値が変更した時に呼び出される関数(引数としてイベントが渡される)

    returns:
    Combobox    ----    生成されたコンボボックスインスタンス
    """
    combobox = ttk.Combobox(master,value=value,state="readonly")
    combobox.bind("<<ComboboxSelected>>",command)
    combobox.place(relwidth=relw,relx=relx,rely=rely,anchor=tk.W)
    combobox.current(0)
    return combobox

def GetRadioButtons(master,dic,relx,rely,relxp,relyp,val,command=None):
    """ラジオボタン選択を作成する

    arguments:
    master      ----    配置ペアレント
    dic         ----    ラジオボタンのtextをkey、ラジオボタンのvalueをvalueにセットした辞書型
    relx        ----    X座標相対位置(左端)
    rely        ----    Y座標相対位置(上下中央)
    relxp       ----    ラジオボタン間左右ピッチ
    relyp       ----    ラジオボタン間上下ピッチ
    val         ----    variableを対応させるwidget変数(例 IntVar())
    command     ----    ラジオボタン変更時ハンドラ関数

    returns:
    ラジオボタンインスタンスリスト
    """
    ret_rbtn = list()
    cnt = 0
    for key in dic.keys():
        ret_rbtn.append(tk.Radiobutton(master,text=key,value=dic[key],variable=val,command=command))
        ret_rbtn[cnt].place(relx = relx+cnt*relxp,rely = rely+cnt*relyp,anchor=tk.W)
        cnt += 1
    return ret_rbtn

def GenTkVarList(N,cls,initval):
    """Tkinter Var list generator with value initialize
    
    arguments:
    N           ----    list length
    cls         ----    tkinter variable class
    initval     ----    initial value
    
    returns:
    list        ----    generated list
    """
    ret = list()
    for i in range(N):
        ret.append(cls(value=initval))
    return ret

# TUSB-16DIF専用ウィジット生成、操作

def GetLEDCanvas(master,relx,rely):
    """LEDランプイメージキャンバス作成
    
    arguments:
    master      ----    配置ペアレント
    relx        ----    X座標相対位置(左右中央)
    rely        ----    Y座標相対位置(上下中央)

    returns:
    Label       ----    生成されたキャンバスインスタンス
    """
    canvas = tk.Canvas(master,width=20,height=20)
    canvas.pack()
    canvas.place(relx=relx,rely=rely,anchor=tk.CENTER)
    return canvas

def SetLEDCanvas(canvas,on):
    """キャンバスにLEDの点灯、消灯イメージを表示

    arguments:
    canvas      ----    描画先キャンバスインスタンス
    on          ----    False:off True:on
    """
    if on == False:
        canvas.create_oval(4,4,19,19,fill="#800000",width=0)
        canvas.create_arc(5,5,18,18,extent=90,start=90,fill="Gray",outline="Gray",style=tk.ARC,width=3)
        canvas.create_arc(8,8,15,15,extent=60,start=120,fill="white",outline="white",style=tk.ARC,width=2)
    else:
        canvas.create_oval(4,4,19,19,fill="#F3ADB5",width=0)
        canvas.create_arc(5,5,18,18,extent=220,start=220,fill="Red",outline="Red",style=tk.ARC,width=3)
        canvas.create_arc(8,8,15,15,extent=60,start=120,fill="white",outline="white",style=tk.ARC,width=2)

def GenList(N,initval):
    """list generator with value initialize"""
    ret = list()
    for i in range(N):
        ret.append(initval)
    return ret

def GenList2D(N1,N2,initval):
    """2D list array generator with value initialize"""
    ret = list()
    for i in range(N1):
        ret.append(GenList(N2,initval))
    return ret

def GenTkVarList(N,cls,initval):
    """Tkinter Var list generator with value initialize
    
    arguments:
    N           ----    list length
    cls         ----    tkinter variable class
    initval     ----    initial value
    
    returns:
    list        ----    generated list
    """
    ret = list()
    for i in range(N):
        ret.append(cls(value=initval))
    return ret

# タイマースレッド管理クラス ////////////////////////////////////
#厳密なインターバルではない。関数処理が終わったら指定時間待つだけ。
#from builtins import function
class intTT():
    """タイマースレッド管理クラス
    厳密なインターバル処理ではない。
    関数処理が終わったら指定時間待って再度実行しつづるループ。
    """
    thread :threading.Thread = None # スレッドクラスオブジェクト
    thread_en : bool = None         # スレッド実行イネーブルフラグ
    call_func = None                # ループで実行する関数
    interval = None                 # ループの待ち時間

    def __init__(self,inttime,callf):
        """初期化"""
        self.interval = inttime # インターバルタイム
        self.call_func = callf  # 処理関数登録
    
    def ThreadF(self):
        """スレッド関数(ループ)"""
        while self.thread_en:
            self.call_func()
            time.sleep(self.interval)

    def Start(self):
        """スレッド開始処理"""
        if self.thread == None:
            self.thread_en = True
            self.thread = threading.Thread(target=self.ThreadF)
            self.thread.start()
    
    def Stop(self):
        """スレッド停止処理"""
        if self.thread_en != None:
            self.thread_en = False
            self.thread.join(self.interval+0.1)
            self.thread = None 

